/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.dao;

import cn.veasion.db.DbException;
import cn.veasion.db.base.Page;
import cn.veasion.db.mybatis.MybatisEntityDao;
import cn.veasion.db.query.AbstractJoinQuery;
import cn.veasion.db.query.AbstractQuery;
import cn.veasion.db.update.AbstractJoinUpdate;
import cn.veasion.db.update.AbstractUpdate;
import cn.veasion.db.update.BatchEntityInsert;
import cn.veasion.db.update.Delete;
import cn.veasion.db.update.EntityInsert;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;

public class CommonDao {
    private CommonJdbcEntityDao dao = new CommonJdbcEntityDao();

    public CommonDao(DataSource dataSource) {
        this.dao.setDataSource(Objects.requireNonNull(dataSource));
    }

    public Object add(EntityInsert entityInsert) {
        Object entity = entityInsert.getEntity();
        if (entity == null) {
            throw new DbException("entity \u4e0d\u80fd\u4e3a\u7a7a");
        }
        entityInsert.check(entity.getClass());
        return this.dao.add(entityInsert);
    }

    public Object[] batchAdd(BatchEntityInsert batchEntityInsert) {
        List entityList = batchEntityInsert.getEntityList();
        if (entityList != null && !entityList.isEmpty()) {
            batchEntityInsert.check(entityList.get(0).getClass());
        } else {
            AbstractQuery query = batchEntityInsert.getInsertSelectQuery();
            if (query instanceof AbstractJoinQuery && query.getEntityClass() != null) {
                batchEntityInsert.check(query.getEntityClass());
            }
        }
        return this.dao.batchAdd(batchEntityInsert);
    }

    public <E> E queryForType(AbstractJoinQuery<?> query, Class<E> clazz) {
        query.check(query.getEntityClass());
        return (E)this.dao.queryForType((AbstractQuery)query, clazz);
    }

    public Map<String, Object> queryForMap(AbstractJoinQuery<?> query, boolean mapUnderscoreToCamelCase) {
        query.check(query.getEntityClass());
        return this.dao.queryForMap((AbstractQuery)query, mapUnderscoreToCamelCase);
    }

    public List<Map<String, Object>> listForMap(AbstractJoinQuery<?> query) {
        query.check(query.getEntityClass());
        return this.listForMap(query, true);
    }

    public List<Map<String, Object>> listForMap(AbstractJoinQuery<?> query, boolean mapUnderscoreToCamelCase) {
        query.check(query.getEntityClass());
        return this.dao.listForMap((AbstractQuery)query, mapUnderscoreToCamelCase);
    }

    public <E> List<E> queryList(AbstractJoinQuery<?> query, Class<E> clazz) {
        query.check(query.getEntityClass());
        return this.dao.queryList((AbstractQuery)query, clazz);
    }

    public <E> Page<E> queryPage(AbstractJoinQuery<?> query, Class<E> clazz) {
        query.check(query.getEntityClass());
        return this.dao.queryPage((AbstractQuery)query, clazz);
    }

    public <E> Page<E> queryPage(AbstractJoinQuery<?> query) {
        query.check(query.getEntityClass());
        return this.dao.queryPage((AbstractQuery)query, query.getEntityClass());
    }

    public int update(AbstractJoinUpdate<?> update) {
        update.check(update.getEntityClass());
        return this.dao.update((AbstractUpdate)update);
    }

    public int delete(Delete delete, Class<?> clazz) {
        delete.check(clazz);
        return this.dao.delete(delete);
    }

    private static class CommonJdbcEntityDao
    extends MybatisEntityDao<Object, Object> {
        private CommonJdbcEntityDao() {
        }

        public Object getById(Object _void) {
            throw new DbException("\u4e0d\u652f\u6301\uff0c\u8bf7\u901a\u8fc7 queryForType \u65b9\u5f0f\u67e5\u8be2");
        }

        public int updateById(Object entity) {
            throw new DbException("\u4e0d\u652f\u6301\uff0c\u8bf7\u901a\u8fc7 update \u65b9\u5f0f\u66f4\u65b0");
        }

        public int deleteById(Object _void) {
            throw new DbException("\u4e0d\u652f\u6301\uff0c\u8bf7\u901a\u8fc7 delete \u65b9\u5f0f\u66f4\u65b0");
        }

        public Class<Object> getEntityClass() {
            return null;
        }
    }
}

