/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.config;

import cn.veasion.project.aspect.IgnoreCompanyIdAspect;
import cn.veasion.project.aspect.LimitAspect;
import cn.veasion.project.aspect.LogAspect;
import cn.veasion.project.dao.CommonDao;
import cn.veasion.project.dao.ReadWriteDataSource;
import cn.veasion.project.dao.ReadWriteTransactionInterceptor;
import cn.veasion.project.service.CacheServiceImpl;
import cn.veasion.project.utils.SpringBeanUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

@Configuration
@Import(value={SpringBeanUtils.class, IgnoreCompanyIdAspect.class, LogAspect.class})
public class ProjectAutoConfiguration {
    @Bean
    @Primary
    @ConditionalOnMissingBean(name={"dataSource"})
    public ReadWriteDataSource dataSource(@Qualifier(value="readDataSource") DataSource readDataSource, @Qualifier(value="writeDataSource") DataSource writeDataSource) {
        ReadWriteDataSource readWriteDataSource = new ReadWriteDataSource();
        readWriteDataSource.setRead(readDataSource);
        readWriteDataSource.setWrite(writeDataSource);
        return readWriteDataSource;
    }

    @Bean
    @ConditionalOnMissingBean(name={"commonDao"})
    public CommonDao commonDao(DataSource dataSource) {
        return new CommonDao(dataSource);
    }

    @Bean
    @ConditionalOnMissingBean(name={"transactionManager"})
    public PlatformTransactionManager transactionManager(@Qualifier(value="dataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    @ConditionalOnMissingBean(name={"defaultBeanFactoryPointcutAdvisor"})
    public DefaultBeanFactoryPointcutAdvisor defaultBeanFactoryPointcutAdvisor(TransactionManager transactionManager, @Qualifier(value="servicePointcut") AspectJExpressionPointcut servicePointcut) {
        DefaultBeanFactoryPointcutAdvisor advisor = new DefaultBeanFactoryPointcutAdvisor();
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        final RuleBasedTransactionAttribute requiredTx = new RuleBasedTransactionAttribute();
        requiredTx.setRollbackRules(Collections.singletonList(new RollbackRuleAttribute(Throwable.class)));
        requiredTx.setPropagationBehavior(0);
        source.setNameMap((Map)new HashMap<String, TransactionAttribute>(){
            {
                this.put("add*", requiredTx);
                this.put("save*", requiredTx);
                this.put("insert*", requiredTx);
                this.put("batchAdd*", requiredTx);
                this.put("update*", requiredTx);
                this.put("delete*", requiredTx);
                this.put("*WithTx", requiredTx);
            }
        });
        ReadWriteTransactionInterceptor interceptor = new ReadWriteTransactionInterceptor();
        interceptor.setTransactionManager(transactionManager);
        interceptor.setTransactionAttributeSource((TransactionAttributeSource)source);
        advisor.setAdvice((Advice)interceptor);
        advisor.setPointcut((Pointcut)servicePointcut);
        return advisor;
    }

    @Configuration
    @ConditionalOnClass(value={RedisTemplate.class})
    @Import(value={CacheServiceImpl.class, LimitAspect.class})
    public static class CacheConfiguration {
    }
}

