/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.aspect;

import cn.hutool.json.JSONUtil;
import cn.veasion.project.aspect.Log;
import cn.veasion.project.model.SysLogVO;
import cn.veasion.project.service.SysLogService;
import cn.veasion.project.session.SessionHelper;
import cn.veasion.project.utils.RequestHolder;
import cn.veasion.project.utils.SpringBeanUtils;
import cn.veasion.project.utils.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Aspect
@Component
public class LogAspect {
    private ThreadLocal<Long> currentTime = new ThreadLocal();

    @Pointcut(value="@annotation(cn.veasion.project.aspect.Log)")
    public void logPointcut() {
    }

    @Around(value="logPointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        this.currentTime.set(System.currentTimeMillis());
        Object result = joinPoint.proceed();
        SysLogVO log = new SysLogVO();
        log.setLogType("INFO");
        log.setCreateTime(new Date());
        log.setTime(System.currentTimeMillis() - this.currentTime.get());
        this.currentTime.remove();
        this.saveLog(log, joinPoint);
        return result;
    }

    @AfterThrowing(pointcut="logPointcut()", throwing="e")
    public void logAfterThrowing(JoinPoint joinPoint, Throwable e) {
        SysLogVO log = new SysLogVO();
        log.setLogType("ERROR");
        log.setTime(System.currentTimeMillis() - this.currentTime.get());
        this.currentTime.remove();
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            e.printStackTrace(pw);
            log.setExceptionDetail(sw.toString());
        }
        this.saveLog(log, (ProceedingJoinPoint)joinPoint);
    }

    private void saveLog(SysLogVO log, ProceedingJoinPoint joinPoint) {
        HttpServletRequest request = Objects.requireNonNull(RequestHolder.getHttpServletRequest());
        String ip = StringUtils.getIp(request);
        String browser = request.getHeader("User-Agent");
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Log aopLog = method.getAnnotation(Log.class);
        String methodName = joinPoint.getTarget().getClass().getName() + "." + signature.getName() + "()";
        log.setDescription(aopLog.value());
        log.setRequestIp(ip);
        log.setMethod(methodName);
        log.setParams(this.getParameter(method, joinPoint.getArgs()));
        log.setBrowser(browser);
        log.setUsername(SessionHelper.getUserName());
        log.setCompanyId(SessionHelper.getCompanyId());
        SysLogService sysLogService = SpringBeanUtils.getBean(SysLogService.class);
        if (sysLogService == null) {
            throw new RuntimeException("SysLogService \u672a\u627e\u5230\u5b9e\u73b0\u7c7b");
        }
        sysLogService.asyncSaveLog(log);
    }

    private String getParameter(Method method, Object[] args) {
        ArrayList<Object> argList = new ArrayList<Object>();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            RequestParam requestParam;
            RequestBody requestBody = parameters[i].getAnnotation(RequestBody.class);
            if (requestBody != null) {
                argList.add(args[i]);
            }
            if ((requestParam = parameters[i].getAnnotation(RequestParam.class)) == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String key = parameters[i].getName();
            if (!StringUtils.isEmpty((CharSequence)requestParam.value())) {
                key = requestParam.value();
            }
            map.put(key, args[i]);
            argList.add(map);
        }
        if (argList.isEmpty()) {
            return "";
        }
        return argList.size() == 1 ? JSONUtil.toJsonStr(argList.get(0)) : JSONUtil.toJsonStr(argList);
    }
}

