/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.project.aspect;

import cn.veasion.project.BusinessException;
import cn.veasion.project.aspect.Limit;
import cn.veasion.project.aspect.LimitParam;
import cn.veasion.project.session.SessionHelper;
import cn.veasion.project.utils.RequestHolder;
import cn.veasion.project.utils.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LimitAspect {
    private final RedisTemplate<String, Object> redisTemplate;

    public LimitAspect(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Pointcut(value="@annotation(cn.veasion.project.aspect.Limit)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Number count;
        HttpServletRequest request;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method signatureMethod = signature.getMethod();
        Limit limit = signatureMethod.getAnnotation(Limit.class);
        StringBuilder key = new StringBuilder("limit:");
        key.append(limit.key());
        if (limit.limitType() == Limit.LimitType.IP) {
            request = RequestHolder.getHttpServletRequest();
            Objects.requireNonNull(request, "\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
            key.append("_").append(StringUtils.getIp(request));
        } else if (limit.limitType() == Limit.LimitType.METHOD_PARAM_ALL) {
            key.append("_").append(Arrays.toString(joinPoint.getArgs()));
        } else if (limit.limitType() == Limit.LimitType.PARAM_ANNOTATION) {
            for (int i = 0; i < signatureMethod.getParameters().length; ++i) {
                Parameter parameter = signatureMethod.getParameters()[i];
                LimitParam annotation = parameter.getAnnotation(LimitParam.class);
                if (annotation == null) continue;
                key.append("_").append(joinPoint.getArgs()[i]);
            }
        } else {
            String userId = SessionHelper.getUserId();
            if (userId != null) {
                key.append("_").append(userId);
            } else {
                HttpServletRequest request2 = RequestHolder.getHttpServletRequest();
                Objects.requireNonNull(request2, "\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
                key.append("_").append(StringUtils.getIp(request2));
            }
        }
        if (limit.requestURI()) {
            request = RequestHolder.getHttpServletRequest();
            Objects.requireNonNull(request, "\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
            key.append("_").append(request.getRequestURI().replace("/", "_"));
        }
        if (null != (count = this.count(key.toString(), limit.maxCount(), limit.periodOfSeconds())) && count.longValue() <= (long)limit.maxCount()) {
            return joinPoint.proceed();
        }
        throw new BusinessException("\u64cd\u4f5c\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    public Number count(String key, int maxCount, int periodOfSeconds) {
        String luaScript = LimitAspect.buildLuaScript();
        DefaultRedisScript redisScript = new DefaultRedisScript(luaScript, Number.class);
        return (Number)this.redisTemplate.execute((RedisScript)redisScript, Collections.singletonList(key), new Object[]{maxCount, periodOfSeconds});
    }

    public static String buildLuaScript() {
        return "local c\nc = redis.call('get', KEYS[1])\nif c and tonumber(c) > tonumber(ARGV[1]) then\nreturn c;\nend\nc = redis.call('incr', KEYS[1])\nif tonumber(c) == 1 then\nredis.call('expire', KEYS[1], ARGV[2])\nend\nreturn c;";
    }
}

