package cn.veasion.project.model;

import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

/**
 * JsonArrayTypeConvert
 *
 * @author luozhuowei
 * @date 2022/6/28
 */
public abstract class JsonArrayTypeConvert<T> extends JsonTypeConvert implements List<T>, Cloneable, RandomAccess, Serializable {

    private final List<T> list;
    private Class<T> elementClass;

    public JsonArrayTypeConvert() {
        this.list = new ArrayList<>();
    }

    public JsonArrayTypeConvert(List<Object> list) {
        if (list == null) {
            throw new IllegalArgumentException("list is null.");
        } else {
            this.list = new ArrayList<>(list.size());
            ParserConfig config = ParserConfig.getGlobalInstance();
            for (Object item : list) {
                T classItem = TypeUtils.cast(item, getElementClass(), config);
                this.list.add(classItem);
            }
        }
    }

    public JsonArrayTypeConvert(int initialCapacity) {
        this.list = new ArrayList<>(initialCapacity);
    }

    @SuppressWarnings("unchecked")
    public Class<T> getElementClass() {
        if (elementClass != null) {
            return elementClass;
        }
        Type genericSuperclass = getClass().getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType) genericSuperclass;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class && JsonArrayTypeConvert.class.isAssignableFrom((Class<?>) rawType)) {
                return (elementClass = (Class<T>) parameterizedType.getActualTypeArguments()[0]);
            }
        }
        throw new RuntimeException("获取类型失败，请重写 getElementClass() 方法");
    }

    @Override
    public int size() {
        return list.size();
    }

    @Override
    public boolean isEmpty() {
        return list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return list.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return list.iterator();
    }

    @Override
    public Object[] toArray() {
        return list.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return list.toArray(a);
    }

    @Override
    public boolean add(T object) {
        return list.add(object);
    }

    @Override
    public boolean remove(Object o) {
        return list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return list.retainAll(c);
    }

    @Override
    public void clear() {
        list.clear();
    }

    @Override
    public T get(int index) {
        return list.get(index);
    }

    @Override
    public T set(int index, T element) {
        return list.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        list.add(index, element);
    }

    @Override
    public T remove(int index) {
        return list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return list.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return list.subList(fromIndex, toIndex);
    }

}
