/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.utils;

import cn.veasion.db.base.Table;
import cn.veasion.db.utils.FieldUtils;
import cn.veasion.db.utils.ServiceLoaderUtils;
import cn.veasion.db.utils.TypeConvert;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Map;

public class TypeUtils {
    static TypeConvert typeConvert = ServiceLoaderUtils.loadOne(TypeConvert.class);

    public static String getTableName(Class<?> entityClazz) {
        Table annotation = entityClazz.getAnnotation(Table.class);
        if (annotation != null) {
            if (!"".equals(annotation.value())) {
                return annotation.value();
            }
            if (annotation.entityClass() != Void.class) {
                return TypeUtils.getTableName(annotation.entityClass());
            }
        }
        return FieldUtils.humpToLine(entityClazz.getSimpleName());
    }

    public static boolean isSimpleClass(Class<?> clazz) {
        return clazz == BigDecimal.class || clazz == Long.class || clazz == Integer.class || clazz == String.class || clazz == Double.class || clazz == Float.class || clazz == Boolean.class || java.util.Date.class.isAssignableFrom(clazz) || clazz == Byte.class || clazz == LocalDateTime.class || clazz == LocalDate.class;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("\u521d\u59cb\u5316\u5bf9\u8c61\u5931\u8d25: " + clazz.getName(), e);
        }
    }

    public static <E> E map2Obj(Map<String, Object> map, Class<E> clazz) throws Exception {
        if (Map.class.isAssignableFrom(clazz) || Object.class.equals(clazz)) {
            return (E)map;
        }
        E instance = clazz.newInstance();
        Map<String, Field> fields = FieldUtils.fields(clazz);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!fields.containsKey(entry.getKey())) continue;
            FieldUtils.setValue(instance, entry.getKey(), entry.getValue(), true);
        }
        return instance;
    }

    public static <T> T convert(Object object, Class<T> clazz) {
        T value;
        if (object == null || clazz == null || clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        if (typeConvert != null && (value = typeConvert.convert(object, clazz)) != null) {
            return value;
        }
        String toStr = object.toString();
        if (clazz == String.class) {
            return (T)toStr;
        }
        if ("".equals(toStr)) {
            return null;
        }
        if (clazz == BigDecimal.class) {
            return (T)new BigDecimal(toStr);
        }
        if (clazz == Long.class) {
            if (object instanceof Number) {
                return (T)new Long(((Number)object).longValue());
            }
            if (toStr.contains(".")) {
                toStr = toStr.split("\\.")[0];
            }
            return (T)Long.valueOf(toStr);
        }
        if (clazz == Double.class) {
            if (object instanceof Number) {
                return (T)new Double(((Number)object).doubleValue());
            }
            return (T)Double.valueOf(toStr);
        }
        if (clazz == Float.class) {
            if (object instanceof Number) {
                return (T)new Float(((Number)object).floatValue());
            }
            return (T)Float.valueOf(toStr);
        }
        if (clazz == Integer.class) {
            if (object instanceof Number) {
                return (T)new Integer(((Number)object).intValue());
            }
            if (object instanceof Boolean) {
                return (T)(Boolean.TRUE.equals(object) ? new Integer(1) : new Integer(0));
            }
            if (toStr.contains(".")) {
                toStr = toStr.split("\\.")[0];
            }
            return (T)Integer.valueOf(toStr);
        }
        if (clazz == Boolean.class) {
            if ("true".equalsIgnoreCase(toStr) || "1".equals(toStr)) {
                return (T)Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(toStr) || "0".equals(toStr)) {
                return (T)Boolean.FALSE;
            }
        } else if (java.util.Date.class.isAssignableFrom(clazz) || Temporal.class.isAssignableFrom(clazz)) {
            T value2 = null;
            if (java.util.Date.class.isAssignableFrom(object.getClass())) {
                value2 = TypeUtils.dateTo((java.util.Date)object, clazz);
            } else if (Temporal.class.isAssignableFrom(object.getClass())) {
                value2 = TypeUtils.temporalTo((Temporal)object, clazz);
            }
            if (value2 == null) {
                java.util.Date date = TypeUtils.toDate(toStr);
                value2 = TypeUtils.dateTo(date, clazz);
            }
            if (value2 != null) {
                return value2;
            }
        } else if (clazz == Byte.class && toStr.matches("-?\\d+")) {
            return (T)new Byte(toStr);
        }
        return (T)object;
    }

    private static <T> T dateTo(java.util.Date date, Class<T> clazz) {
        if (date == null) {
            return null;
        }
        if (clazz == java.util.Date.class) {
            return (T)date;
        }
        if (clazz == Date.class) {
            return (T)new Date(date.getTime());
        }
        if (clazz == Timestamp.class) {
            return (T)new Timestamp(date.getTime());
        }
        if (clazz == LocalDateTime.class) {
            return (T)LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        if (clazz == LocalDate.class) {
            return (T)LocalDate.from(date.toInstant());
        }
        if (clazz == LocalTime.class) {
            return (T)LocalTime.from(date.toInstant());
        }
        return null;
    }

    private static <T> T temporalTo(Temporal temporal, Class<T> clazz) {
        java.util.Date date = null;
        if (temporal instanceof LocalDateTime) {
            date = java.util.Date.from(((LocalDateTime)temporal).atZone(ZoneId.systemDefault()).toInstant());
        } else if (temporal instanceof LocalDate) {
            date = java.util.Date.from(((LocalDate)temporal).atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        if (date == null) {
            return (T)temporal;
        }
        return TypeUtils.dateTo(date, clazz);
    }

    private static java.util.Date toDate(String toStr) {
        try {
            if (toStr.matches("\\d+")) {
                return new java.util.Date(Long.parseLong(toStr));
            }
            if (toStr.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(toStr);
            }
            if (toStr.matches("\\d{4}-\\d{2}-\\d{2}")) {
                return new SimpleDateFormat("yyyy-MM-dd").parse(toStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

