/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.utils;

import cn.veasion.db.jdbc.DataSourceProvider;
import cn.veasion.db.jdbc.DynamicTableExt;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceLoaderUtils {
    private static Logger logger = LoggerFactory.getLogger(ServiceLoaderUtils.class);
    private static DataSourceProvider dataSourceProvider;
    private static DynamicTableExt dynamicTableExt;

    public static synchronized DataSourceProvider dataSourceProvider() {
        if (dataSourceProvider != null) {
            return dataSourceProvider;
        }
        List<DataSourceProvider> list = ServiceLoaderUtils.loadList(DataSourceProvider.class);
        if (list.size() > 0) {
            dataSourceProvider = list.get(0);
        }
        if (list.size() > 1) {
            logger.warn("\u53d1\u73b0\u591a\u4e2adataSourceProvider");
        }
        if (dataSourceProvider == null) {
            logger.warn("dataSourceProvider\u672a\u83b7\u53d6\u5230\u5b9e\u4f8b");
        }
        return dataSourceProvider;
    }

    public static synchronized DynamicTableExt dynamicTableExt() {
        if (dynamicTableExt != null) {
            return dynamicTableExt;
        }
        dynamicTableExt = ServiceLoaderUtils.loadOne(DynamicTableExt.class);
        return dynamicTableExt;
    }

    public static <T> T loadOne(Class<T> clazz) {
        List<T> list = ServiceLoaderUtils.loadList(clazz);
        return list.size() > 0 ? (T)list.get(0) : null;
    }

    public static <T> List<T> loadList(Class<T> clazz) {
        ArrayList list = new ArrayList();
        ServiceLoader.load(clazz).forEach(list::add);
        return list;
    }
}

