/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.utils;

import cn.veasion.db.FilterException;
import cn.veasion.db.base.Filter;
import cn.veasion.db.base.Operator;
import java.util.Collection;
import java.util.Iterator;

public class FilterUtils {
    public static Filter checkFilter(Filter filter) {
        return filter;
    }

    public static boolean hasFilter(Filter filter) {
        if (filter == null) {
            return false;
        }
        if (filter.getSql() != null && filter.getSql().contains("?")) {
            return filter.getValue() != null;
        }
        return true;
    }

    public static String tableAsField(String tableAs, String field) {
        if (field == null) {
            return null;
        }
        if ("-".equals(tableAs)) {
            int idx = field.indexOf(".");
            if (idx > -1) {
                field = field.substring(idx + 1);
            }
        } else if (tableAs != null && !field.contains(".")) {
            field = tableAs + "." + field;
        }
        return field;
    }

    public static Filter getFilter(String field, Operator operator, Object value) {
        if (Operator.EQ.equals((Object)operator)) {
            return Filter.eq(field, value);
        }
        if (Operator.NEQ.equals((Object)operator)) {
            return Filter.neq(field, value);
        }
        if (Operator.GT.equals((Object)operator)) {
            return Filter.gt(field, value);
        }
        if (Operator.GTE.equals((Object)operator)) {
            return Filter.gte(field, value);
        }
        if (Operator.LT.equals((Object)operator)) {
            return Filter.lt(field, value);
        }
        if (Operator.LTE.equals((Object)operator)) {
            return Filter.lte(field, value);
        }
        if (Operator.IN.equals((Object)operator)) {
            if (value instanceof Collection) {
                return Filter.in(field, (Collection)value);
            }
            if (value instanceof Object[]) {
                return Filter.in(field, (Object[])value);
            }
            throw new FilterException(field + " \u5b57\u6bb5 Operator.IN \u7c7b\u578b\u5fc5\u987b\u662f\u96c6\u5408\u6216\u8005\u6570\u7ec4");
        }
        if (Operator.NOT_IN.equals((Object)operator)) {
            if (value instanceof Collection) {
                return Filter.notIn(field, (Collection)value);
            }
            if (value instanceof Object[]) {
                return Filter.notIn(field, (Object[])value);
            }
            throw new FilterException(field + " \u5b57\u6bb5 Operator.IN \u7c7b\u578b\u5fc5\u987b\u662f\u96c6\u5408\u6216\u8005\u6570\u7ec4");
        }
        if (Operator.LIKE.equals((Object)operator)) {
            if (value instanceof String) {
                String str = (String)value;
                if (str.startsWith("%") && str.endsWith("%")) {
                    return Filter.like(field, str.substring(1, str.length() - 1));
                }
                if (str.startsWith("%")) {
                    return Filter.likeLeft(field, str.substring(1));
                }
                if (str.endsWith("%")) {
                    return Filter.likeRight(field, str.substring(0, str.length() - 1));
                }
            }
            return Filter.like(field, value);
        }
        if (Operator.BETWEEN.equals((Object)operator)) {
            if (value instanceof Collection) {
                Iterator iterator = ((Collection)value).iterator();
                return Filter.between(field, iterator.next(), iterator.next());
            }
            if (value instanceof Object[]) {
                Object[] objects = (Object[])value;
                return Filter.between(field, objects[0], objects[1]);
            }
            throw new FilterException(field + " \u5b57\u6bb5 Operator.BETWEEN \u7c7b\u578b\u5fc5\u987b\u662f\u96c6\u5408\u6216\u8005\u6570\u7ec4");
        }
        if (Operator.NULL.equals((Object)operator) && !Boolean.FALSE.equals(value)) {
            return Filter.isNull(field);
        }
        if (Operator.NOT_NULL.equals((Object)operator) && !Boolean.FALSE.equals(value)) {
            return Filter.isNotNull(field);
        }
        throw new FilterException(field + " \u4e0d\u652f\u6301 Operator." + operator.name());
    }
}

