/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.utils;

import cn.veasion.db.DbException;
import cn.veasion.db.base.Column;
import cn.veasion.db.base.Table;
import cn.veasion.db.utils.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldUtils {
    private static final Pattern LINE_PATTERN = Pattern.compile("_(\\w)");
    private static final Pattern HUMP_PATTERN = Pattern.compile("[a-z][A-Z]");
    private static Map<Class<?>, Map<String, String>> FIELD_COLUMN_CACHE = new HashMap();
    private static Map<Class<?>, Map<String, Field>> FIELD_CACHE = new HashMap();
    private static Map<Class<?>, Map<String, Method>> METHOD_GET_CACHE = new HashMap();
    private static Map<Class<?>, Map<String, Method>> METHOD_SET_CACHE = new HashMap();

    public static Map<String, String> entityFieldColumns(Class<?> entityClazz) {
        Table annotation = entityClazz.getAnnotation(Table.class);
        if (annotation != null && annotation.entityClass() != Void.class) {
            return FieldUtils.fieldColumns(annotation.entityClass());
        }
        return FieldUtils.fieldColumns(entityClazz);
    }

    public static Field getIdField(Class<?> entityClazz) {
        Table annotation = entityClazz.getAnnotation(Table.class);
        if (annotation != null) {
            String field = annotation.idField();
            if (!"".equals(field)) {
                return FieldUtils.getField(entityClazz, field);
            }
            if (annotation.entityClass() != Void.class) {
                return FieldUtils.getIdField(annotation.entityClass());
            }
        }
        return FieldUtils.getField(entityClazz, "id");
    }

    public static Field getField(Class<?> clazz, String field) {
        return FieldUtils.fields(clazz).get(field);
    }

    public static Map<String, String> fieldColumns(Class<?> entityClazz) {
        Map<String, String> fieldColumnMap = FIELD_COLUMN_CACHE.get(entityClazz);
        if (fieldColumnMap != null) {
            return fieldColumnMap;
        }
        if (TypeUtils.isSimpleClass(entityClazz)) {
            return new HashMap<String, String>();
        }
        fieldColumnMap = new HashMap<String, String>();
        Map<String, Field> fieldMap = FieldUtils.fields(entityClazz);
        for (Field field : fieldMap.values()) {
            Column column = field.getAnnotation(Column.class);
            if (column != null && column.ignore()) continue;
            if (column != null && !"".equals(column.value())) {
                fieldColumnMap.put(field.getName(), column.value());
                continue;
            }
            fieldColumnMap.put(field.getName(), FieldUtils.humpToLine(field.getName()));
        }
        FIELD_COLUMN_CACHE.put(entityClazz, Collections.unmodifiableMap(fieldColumnMap));
        return fieldColumnMap;
    }

    public static Object getValue(Object object, String field) {
        return FieldUtils.getValue(object, field, true);
    }

    public static Object getValue(Object object, String field, boolean force) {
        try {
            Map<String, Method> methodMap = FieldUtils.getterMethod(object.getClass());
            if (methodMap.containsKey(field)) {
                return methodMap.get(field).invoke(object, new Object[0]);
            }
            Field f = FieldUtils.getField(object, field);
            if (f != null) {
                f.setAccessible(true);
                return f.get(object);
            }
            if (force) {
                throw new IllegalAccessException(field + " \u5b57\u6bb5\u4e0d\u5b58\u5728\uff1a" + object.getClass().getName());
            }
            return null;
        }
        catch (Exception e) {
            throw new DbException("\u5b57\u6bb5\u83b7\u53d6\u503c\u5f02\u5e38: " + field, e);
        }
    }

    public static boolean setValue(Object object, String field, Object value) {
        return FieldUtils.setValue(object, field, value, false);
    }

    public static boolean setValue(Object object, String field, Object value, boolean typeAutoConvert) {
        try {
            Map<String, Method> methodMap = FieldUtils.setterMethod(object.getClass());
            if (methodMap.containsKey(field)) {
                Method method = methodMap.get(field);
                if (typeAutoConvert) {
                    method.invoke(object, TypeUtils.convert(value, method.getParameterTypes()[0]));
                } else {
                    method.invoke(object, value);
                }
                return true;
            }
            Field f = FieldUtils.getField(object, field);
            if (f != null) {
                f.setAccessible(true);
                if (typeAutoConvert) {
                    f.set(object, TypeUtils.convert(value, f.getType()));
                } else {
                    f.set(object, value);
                }
            }
            return f != null;
        }
        catch (Exception e) {
            throw new DbException("\u5b57\u6bb5\u8d4b\u503c\u5f02\u5e38: " + field, e);
        }
    }

    private static Field getField(Object object, String field) {
        Map<String, Field> fieldMap = FieldUtils.fields(object.getClass());
        Field f = fieldMap.get(field);
        if (f == null) {
            for (Field _field : fieldMap.values()) {
                Column annotation = _field.getAnnotation(Column.class);
                if (annotation == null || !field.equals(annotation.value())) continue;
                f = _field;
                break;
            }
        }
        return f;
    }

    public static Map<String, Method> getterMethod(Class<?> clazz) {
        Method[] methods;
        Map<String, Method> result = METHOD_GET_CACHE.get(clazz);
        if (result != null) {
            return result;
        }
        result = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || Object.class.equals(method.getDeclaringClass()) || method.getParameterCount() != 0 || !methodName.startsWith("get")) continue;
            String field = FieldUtils.firstCase(methodName.substring(3), true);
            result.put(field, method);
        }
        METHOD_GET_CACHE.put(clazz, Collections.unmodifiableMap(result));
        return result;
    }

    public static Map<String, Method> setterMethod(Class<?> clazz) {
        Method[] methods;
        Map<String, Method> result = METHOD_SET_CACHE.get(clazz);
        if (result != null) {
            return result;
        }
        result = new HashMap<String, Method>();
        for (Method method : methods = clazz.getMethods()) {
            String methodName = method.getName();
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || Object.class.equals(method.getDeclaringClass()) || method.getParameterCount() != 1 || !methodName.startsWith("set")) continue;
            String field = FieldUtils.firstCase(methodName.substring(3), true);
            if (result.containsKey(field)) {
                Field f = FieldUtils.fields(clazz).get(field);
                if (f == null || !f.getType().equals(method.getParameterTypes()[0])) continue;
                result.put(field, method);
                continue;
            }
            result.put(field, method);
        }
        METHOD_SET_CACHE.put(clazz, Collections.unmodifiableMap(result));
        return result;
    }

    public static Map<String, Field> fields(Class<?> clazz) {
        Map<String, Field> result = FIELD_CACHE.get(clazz);
        if (result != null) {
            return result;
        }
        result = new HashMap<String, Field>();
        ArrayList classList = new ArrayList();
        for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            classList.add(0, currentClazz);
        }
        for (Class clazz2 : classList) {
            Field[] fields;
            for (Field field : fields = clazz2.getDeclaredFields()) {
                if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                result.put(field.getName(), field);
            }
        }
        FIELD_CACHE.put(clazz, Collections.unmodifiableMap(result));
        return result;
    }

    public static String lineToHump(String str) {
        if (!(str = str.trim()).contains("_")) {
            return str;
        }
        Matcher matcher = LINE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        String result = sb.toString();
        if (str.startsWith("_")) {
            result = result.length() == 1 ? result.toLowerCase() : result.substring(0, 1).toLowerCase() + result.substring(1);
        }
        return result;
    }

    public static String humpToLine(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        Matcher matcher = HUMP_PATTERN.matcher(str.trim());
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String s = matcher.group();
            s = s.substring(0, 1) + "_" + s.substring(1).toLowerCase();
            matcher.appendReplacement(sb, s);
        }
        matcher.appendTail(sb);
        sb.setCharAt(0, String.valueOf(sb.charAt(0)).toLowerCase().charAt(0));
        return sb.toString();
    }

    public static String firstCase(String str, boolean toLowerCase) {
        if (str.length() == 1) {
            return toLowerCase ? str.toLowerCase() : str.toUpperCase();
        }
        return (toLowerCase ? str.substring(0, 1).toLowerCase() : str.substring(0, 1).toUpperCase()) + str.substring(1);
    }

    public static Map<String, String> parsePlaceholder(String eval, String start, String end) {
        int index = -1;
        HashMap<String, String> result = new HashMap<String, String>();
        while ((index = eval.indexOf(start, index + 1)) > -1) {
            int endIdx = eval.indexOf(end, index + start.length());
            if (endIdx <= -1) continue;
            String key = eval.substring(index, endIdx + end.length());
            result.put(key, key.substring(start.length(), key.length() - 1).trim());
            index = endIdx + end.length() - 1;
        }
        return result;
    }

    public static String replaceSqlPlaceholder(String eval, String tableAs, BiFunction<String, String, String> asFieldColumnFun) {
        return FieldUtils.replaceSqlPlaceholder(eval, tableAs, asFieldColumnFun, "${", "}");
    }

    public static String replaceSqlPlaceholder(String eval, String tableAs, BiFunction<String, String, String> asFieldColumnFun, String start, String end) {
        int index;
        int startIndex = 0;
        int startLen = start.length();
        StringBuilder sb = new StringBuilder();
        while ((index = eval.indexOf(start, startIndex)) > -1) {
            int endIdx = eval.indexOf(end, index + startLen);
            if (endIdx > -1) {
                sb.append(eval.substring(startIndex, index));
                String key = eval.substring(index + startLen, endIdx).trim();
                int idx = key.indexOf(".");
                String as = tableAs;
                if (idx > -1) {
                    as = key.substring(0, idx);
                    sb.append(as).append(".");
                    key = key.substring(idx + 1).trim();
                } else if (tableAs != null) {
                    sb.append(tableAs).append(".");
                }
                if (asFieldColumnFun != null) {
                    sb.append(asFieldColumnFun.apply(as, key));
                } else {
                    sb.append(key);
                }
                startIndex = endIdx + end.length();
                continue;
            }
            sb.append(eval.substring(startIndex, index));
            startIndex = index + 1;
        }
        if (startIndex < eval.length()) {
            sb.append(eval.substring(startIndex));
        }
        return sb.toString();
    }

    public static List<Class<?>> fieldActualType(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            Type[] arguments;
            ArrayList classes = new ArrayList();
            for (Type argument : arguments = ((ParameterizedType)genericType).getActualTypeArguments()) {
                if (argument instanceof Class) {
                    classes.add((Class)argument);
                    continue;
                }
                if (!(argument instanceof WildcardType)) continue;
                classes.add((Class)((WildcardType)argument).getUpperBounds()[0]);
            }
            return classes;
        }
        return null;
    }
}

