/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.update;

import cn.veasion.db.AbstractFilter;
import cn.veasion.db.DbException;
import cn.veasion.db.base.Filter;
import cn.veasion.db.base.JoinType;
import cn.veasion.db.base.Operator;
import cn.veasion.db.query.SubQueryParam;
import cn.veasion.db.update.EntityUpdate;
import cn.veasion.db.utils.FilterUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JoinUpdateParam {
    private JoinType joinType;
    private EntityUpdate mainUpdate;
    private EntityUpdate joinUpdate;
    private List<Filter> onFilters;

    public JoinUpdateParam(EntityUpdate mainUpdate, JoinType joinType, EntityUpdate joinUpdate) {
        this.joinType = joinType;
        this.mainUpdate = mainUpdate;
        this.joinUpdate = joinUpdate;
    }

    public JoinUpdateParam on(Filter filter) {
        Objects.requireNonNull(filter, "\u8fc7\u6ee4\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.onFilters == null) {
            this.onFilters = new ArrayList<Filter>();
        }
        if (filter.isSpecial() && filter.getValue() instanceof SubQueryParam) {
            throw new DbException("on\u6761\u4ef6\u4e0d\u652f\u6301\u5b50\u67e5\u8be2");
        }
        this.onFilters.add(filter);
        AbstractFilter.checkFilter(null, this.onFilters, false);
        return this;
    }

    public JoinUpdateParam on(String mainField, String joinField) {
        mainField = FilterUtils.tableAsField(this.mainUpdate.getTableAs(), mainField);
        joinField = FilterUtils.tableAsField(this.joinUpdate.getTableAs(), joinField);
        return this.on(Filter.expression(mainField, Operator.EQ, "${" + joinField + "}", new Object[0]));
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public EntityUpdate getMainUpdate() {
        return this.mainUpdate;
    }

    public EntityUpdate getJoinUpdate() {
        return this.joinUpdate;
    }

    public List<Filter> getOnFilters() {
        return this.onFilters;
    }
}

