/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.update;

import cn.veasion.db.base.Expression;
import cn.veasion.db.base.Filter;
import cn.veasion.db.base.JoinType;
import cn.veasion.db.base.JoinTypeEnum;
import cn.veasion.db.base.Operator;
import cn.veasion.db.update.AbstractUpdate;
import cn.veasion.db.update.JoinUpdateParam;
import cn.veasion.db.utils.FieldUtils;
import cn.veasion.db.utils.FilterUtils;
import cn.veasion.db.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class EntityUpdate
extends AbstractUpdate<EntityUpdate> {
    private String tableAs;
    private Object entity;
    private List<String> updateFields;
    private List<JoinUpdateParam> joins;
    private List<JoinUpdateParam> relations;
    private boolean excludeUpdateFilterFields;

    public EntityUpdate(Object entity) {
        this(entity, null);
    }

    public EntityUpdate(Object entity, String alias) {
        this.entity = entity;
        this.setEntityClass(entity.getClass());
        this.tableAs = alias == null || "".equals(alias) ? null : alias;
    }

    public EntityUpdate(Class<?> clazz) {
        this(clazz, null);
    }

    public EntityUpdate(Class<?> clazz, String alias) {
        this(TypeUtils.newInstance(clazz), alias);
    }

    public EntityUpdate updateFields(String ... fields) {
        if (this.updateFields == null) {
            this.updateFields = new ArrayList<String>();
        }
        this.updateFields.addAll(Arrays.asList(fields));
        return this;
    }

    public EntityUpdate eq(String field) {
        return (EntityUpdate)this.addFilter(Filter.eq(field, FieldUtils.getValue(this.entity, field)));
    }

    public EntityUpdate excludeUpdateFilterFields() {
        this.excludeUpdateFilterFields = true;
        return this;
    }

    public JoinUpdateParam join(EntityUpdate entityUpdate) {
        return this.join(entityUpdate, JoinTypeEnum.JOIN);
    }

    public JoinUpdateParam leftJoin(EntityUpdate entityUpdate) {
        return this.join(entityUpdate, JoinTypeEnum.LEFT_JOIN);
    }

    public JoinUpdateParam rightJoin(EntityUpdate entityUpdate) {
        return this.join(entityUpdate, JoinTypeEnum.RIGHT_JOIN);
    }

    public JoinUpdateParam fullJoin(EntityUpdate entityUpdate) {
        return this.join(entityUpdate, JoinTypeEnum.FULL_JOIN);
    }

    private JoinUpdateParam join(EntityUpdate entityUpdate, JoinType joinType) {
        if (this.joins == null) {
            this.joins = new ArrayList<JoinUpdateParam>();
        }
        JoinUpdateParam joinQueryParam = new JoinUpdateParam(this, joinType, entityUpdate);
        this.joins.add(joinQueryParam);
        return joinQueryParam;
    }

    @Override
    protected String handleField(String field) {
        return FilterUtils.tableAsField(this.tableAs, field);
    }

    @Override
    public EntityUpdate updateExpression(String field, Expression expression) {
        if (expression == null) {
            return this;
        }
        return (EntityUpdate)super.updateExpression(field, expression.tableAs(this.tableAs));
    }

    @Override
    public EntityUpdate filterExpression(String field, Operator operator, Expression expression) {
        return (EntityUpdate)super.filterExpression(field, operator, expression.tableAs(this.tableAs));
    }

    @Override
    protected Filter handleFilter(Filter filter) {
        return filter.fieldAs(this.tableAs);
    }

    @Override
    public void check(Class<?> mainEntityClass) {
        if (this.joins != null) {
            this.relations = new ArrayList<JoinUpdateParam>();
        }
        this.check(mainEntityClass, this, true);
    }

    private void check(Class<?> mainEntityClass, EntityUpdate mainUpdate, boolean main) {
        if (main && !this.checked && EntityUpdate.isEmptyUpdate(this)) {
            Map<String, String> fieldColumns = FieldUtils.entityFieldColumns(this.entity.getClass());
            if (this.updateFields == null) {
                this.updateFields = new ArrayList<String>(fieldColumns.size());
            }
            this.updateFields.addAll(fieldColumns.keySet());
        }
        if (this.updateFields != null) {
            for (String updateField : this.updateFields) {
                if (this.excludeUpdateFilterFields && this.hasFilter(updateField)) continue;
                this.update(updateField, FieldUtils.getValue(this.entity, updateField));
            }
        }
        super.check(mainEntityClass);
        if (this.joins != null) {
            for (JoinUpdateParam join : this.joins) {
                if (!main) {
                    mainUpdate.relations.add(join);
                }
                join.getJoinUpdate().check(mainEntityClass, mainUpdate, false);
            }
        }
    }

    private static boolean isEmptyUpdate(EntityUpdate update) {
        boolean emptyUpdate;
        boolean bl = emptyUpdate = update.getUpdates().isEmpty() && (update.updateFields == null || update.updateFields.isEmpty());
        if (emptyUpdate && update.joins != null) {
            for (JoinUpdateParam join : update.joins) {
                if (EntityUpdate.isEmptyUpdate(join.getJoinUpdate())) continue;
                emptyUpdate = false;
                break;
            }
        }
        return emptyUpdate;
    }

    public String getTableAs() {
        return this.tableAs;
    }

    public Object getEntity() {
        return this.entity;
    }

    public List<JoinUpdateParam> getJoins() {
        return this.joins;
    }

    public List<JoinUpdateParam> getJoinAll() {
        if (this.joins == null || this.relations == null) {
            return this.joins;
        }
        ArrayList<JoinUpdateParam> joinList = new ArrayList<JoinUpdateParam>(this.joins.size() + this.relations.size());
        joinList.addAll(this.joins);
        joinList.addAll(this.relations);
        return joinList;
    }

    @Override
    protected EntityUpdate getSelf() {
        return this;
    }
}

