/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.update;

import cn.veasion.db.jdbc.InsertSQL;
import cn.veasion.db.utils.FieldUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class EntityInsert {
    private Object entity;
    private Class<?> entityClass;
    private Set<String> skipFields;
    private Map<String, Object> fieldValueMap;

    public EntityInsert(Object entity) {
        this.entity = Objects.requireNonNull(entity);
    }

    public EntityInsert(Object entity, String ... skipFields) {
        this(entity);
        if (skipFields.length > 0) {
            this.skipFields = new HashSet<String>(Arrays.asList(skipFields));
        }
    }

    public Object getEntity() {
        return this.entity;
    }

    public Map<String, Object> getFieldValueMap() {
        return this.fieldValueMap;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public void check(Class<?> mainEntityClass) {
        if (this.entityClass == null) {
            this.setEntityClass(mainEntityClass);
        }
        this.fieldValueMap = new HashMap<String, Object>();
        Map<String, String> fieldColumns = FieldUtils.entityFieldColumns(this.entityClass);
        for (String field : fieldColumns.keySet()) {
            if (this.skipFields != null && this.skipFields.contains(field)) continue;
            this.fieldValueMap.put(field, FieldUtils.getValue(this.entity, field, false));
        }
    }

    public InsertSQL sqlValue() {
        return InsertSQL.build(this);
    }
}

