/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.update;

import cn.veasion.db.DbException;
import cn.veasion.db.jdbc.InsertSQL;
import cn.veasion.db.query.AbstractQuery;
import cn.veasion.db.utils.FieldUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BatchEntityInsert {
    private List<?> entityList;
    private Class<?> entityClass;
    private Set<String> skipFields;
    private AbstractQuery<?> insertSelectQuery;
    private List<Map<String, Object>> fieldValueMapList;

    public <T> BatchEntityInsert(List<T> entityList) {
        this.entityList = Objects.requireNonNull(entityList);
    }

    public <T> BatchEntityInsert(List<T> entityList, String ... skipFields) {
        this(entityList);
        if (skipFields.length > 0) {
            this.skipFields = new HashSet<String>(Arrays.asList(skipFields));
        }
    }

    public BatchEntityInsert(AbstractQuery<?> insertSelectQuery) {
        this.insertSelectQuery = Objects.requireNonNull(insertSelectQuery);
    }

    public List<?> getEntityList() {
        return this.entityList;
    }

    public List<Map<String, Object>> getFieldValueMapList() {
        return this.fieldValueMapList;
    }

    public AbstractQuery<?> getInsertSelectQuery() {
        return this.insertSelectQuery;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public void check(Class<?> mainEntityClass) {
        if (this.entityClass == null) {
            this.setEntityClass(mainEntityClass);
        }
        if (this.insertSelectQuery != null) {
            return;
        }
        if (this.entityList == null || this.entityList.isEmpty()) {
            throw new DbException("\u6279\u91cf\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.fieldValueMapList = new ArrayList<Map<String, Object>>(this.entityList.size());
        Map<String, String> fieldColumns = FieldUtils.entityFieldColumns(this.entityClass);
        for (Object entity : this.entityList) {
            HashMap<String, Object> fieldValueMap = new HashMap<String, Object>();
            for (String field : fieldColumns.keySet()) {
                if (this.skipFields != null && this.skipFields.contains(field)) continue;
                fieldValueMap.put(field, FieldUtils.getValue(entity, field, false));
            }
            this.fieldValueMapList.add(fieldValueMap);
        }
    }

    public InsertSQL sqlValue() {
        return InsertSQL.build(this);
    }
}

