/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.update;

import cn.veasion.db.AbstractFilter;
import cn.veasion.db.base.Expression;
import cn.veasion.db.jdbc.UpdateSQL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractUpdate<T extends AbstractUpdate<?>>
extends AbstractFilter<T> {
    private boolean skipNullField;
    private Set<String> excludeUpdates;
    private Map<String, Object> updates = new HashMap<String, Object>();

    public T skipNullField() {
        this.skipNullField = true;
        return (T)((AbstractUpdate)this.getSelf());
    }

    public T update(String field, Object value) {
        if (this.skipNullField && value == null) {
            return (T)((AbstractUpdate)this.getSelf());
        }
        field = this.handleField(field);
        if (this.excludeUpdates != null && this.excludeUpdates.contains(field)) {
            return (T)((AbstractUpdate)this.getSelf());
        }
        this.updates.put(field, value);
        return (T)((AbstractUpdate)this.getSelf());
    }

    public T updateExpression(String field, String expression, Object ... values) {
        return this.updateExpression(field, Expression.update(expression, values));
    }

    public T updateExpression(String field, Expression expression) {
        this.updates.put(this.handleField(field), Objects.requireNonNull(expression));
        return (T)((AbstractUpdate)this.getSelf());
    }

    public T excludeUpdates(String ... fields) {
        if (this.excludeUpdates == null) {
            this.excludeUpdates = new HashSet<String>();
        }
        for (String field : fields) {
            this.excludeUpdates.add(this.handleField(field));
        }
        return (T)((AbstractUpdate)this.getSelf());
    }

    public boolean isSkipNullField() {
        return this.skipNullField;
    }

    public Map<String, Object> getUpdates() {
        return this.updates;
    }

    protected abstract String handleField(String var1);

    @Override
    public void check(Class<?> mainEntityClass) {
        super.check(mainEntityClass);
        if (this.skipNullField || this.excludeUpdates != null) {
            ArrayList<String> removes = new ArrayList<String>();
            for (Map.Entry<String, Object> entry : this.updates.entrySet()) {
                if (this.skipNullField && entry.getValue() == null) {
                    removes.add(entry.getKey());
                    continue;
                }
                if (this.excludeUpdates == null || !this.excludeUpdates.contains(entry.getKey())) continue;
                removes.add(entry.getKey());
            }
            if (removes.size() > 0) {
                removes.forEach(this.updates::remove);
            }
        }
    }

    public Set<String> getExcludeUpdates() {
        return this.excludeUpdates;
    }

    public UpdateSQL sqlValue() {
        return UpdateSQL.build(this);
    }
}

