/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.query;

import cn.veasion.db.AbstractFilter;
import cn.veasion.db.DbException;
import cn.veasion.db.base.Filter;
import cn.veasion.db.base.JoinType;
import cn.veasion.db.base.Operator;
import cn.veasion.db.query.AbstractJoinQuery;
import cn.veasion.db.query.SubQueryParam;
import cn.veasion.db.utils.FilterUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JoinQueryParam {
    private JoinType joinType;
    private AbstractJoinQuery<?> mainQuery;
    private AbstractJoinQuery<?> joinQuery;
    private List<Filter> onFilters;

    public JoinQueryParam(AbstractJoinQuery<?> mainQuery, JoinType joinType, AbstractJoinQuery<?> joinQuery) {
        this.joinType = joinType;
        this.mainQuery = mainQuery;
        this.joinQuery = joinQuery;
    }

    public JoinQueryParam on(String mainField, String joinField) {
        mainField = FilterUtils.tableAsField(this.mainQuery.getTableAs(), mainField);
        joinField = FilterUtils.tableAsField(this.joinQuery.getTableAs(), joinField);
        return this.on(Filter.expression(mainField, Operator.EQ, "${" + joinField + "}", new Object[0]));
    }

    public JoinQueryParam on(Filter filter) {
        Objects.requireNonNull(filter, "\u8fc7\u6ee4\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.onFilters == null) {
            this.onFilters = new ArrayList<Filter>();
        }
        if (filter.isSpecial() && filter.getValue() instanceof SubQueryParam) {
            throw new DbException("on\u6761\u4ef6\u4e0d\u652f\u6301\u5b50\u67e5\u8be2");
        }
        this.onFilters.add(filter);
        AbstractFilter.checkFilter(null, this.onFilters, false);
        return this;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public AbstractJoinQuery<?> getMainQuery() {
        return this.mainQuery;
    }

    public AbstractJoinQuery<?> getJoinQuery() {
        return this.joinQuery;
    }

    public List<Filter> getOnFilters() {
        return this.onFilters;
    }
}

