/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.query;

import cn.veasion.db.AbstractFilter;
import cn.veasion.db.base.Expression;
import cn.veasion.db.base.Filter;
import cn.veasion.db.jdbc.QuerySQL;
import cn.veasion.db.query.MysqlPage;
import cn.veasion.db.query.OrderParam;
import cn.veasion.db.query.PageParam;
import cn.veasion.db.query.SubQueryParam;
import cn.veasion.db.query.UnionQueryParam;
import cn.veasion.db.utils.FieldUtils;
import cn.veasion.db.utils.FilterUtils;
import cn.veasion.db.utils.ServiceLoaderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractQuery<T extends AbstractQuery<?>>
extends AbstractFilter<T> {
    private boolean distinct;
    protected boolean selectAll;
    protected List<String> selects = new ArrayList<String>();
    protected Map<String, String> aliasMap = new HashMap<String, String>();
    private Set<String> excludeSelects;
    private List<Expression> selectExpression;
    private List<SubQueryParam> selectSubQueryList;
    private List<String> groupBys;
    private List<OrderParam> orders;
    private List<Filter> having;
    private List<UnionQueryParam> unions;
    private PageParam pageParam;

    public T distinct() {
        this.distinct = true;
        return (T)((AbstractQuery)this.getSelf());
    }

    public T selectAll() {
        this.selectAll = true;
        return (T)((AbstractQuery)this.getSelf());
    }

    public T select(String field) {
        return this.select(field, null);
    }

    public T select(String field, String alias) {
        field = this.handleField(field);
        this.selects.add(field);
        if (alias != null) {
            this.aliasMap.put(field, alias);
        }
        return (T)((AbstractQuery)this.getSelf());
    }

    public T selects(String ... fields) {
        for (String field : fields) {
            this.select(field);
        }
        return (T)((AbstractQuery)this.getSelf());
    }

    public T selectSubQuery(SubQueryParam subQueryParam) {
        Objects.requireNonNull(subQueryParam, "\u5b50\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.selectSubQueryList == null) {
            this.selectSubQueryList = new ArrayList<SubQueryParam>();
        }
        this.selectSubQueryList.add(subQueryParam);
        return (T)((AbstractQuery)this.getSelf());
    }

    public T selectExpression(String expression, String alias, Object ... values) {
        return this.selectExpression(Expression.select(expression, alias, values));
    }

    public T selectExpression(Expression expression) {
        if (this.selectExpression == null) {
            this.selectExpression = new ArrayList<Expression>();
        }
        this.selectExpression.add(Objects.requireNonNull(expression));
        return (T)((AbstractQuery)this.getSelf());
    }

    public T alias(String field, String alias) {
        this.aliasMap.put(this.handleField(field), Objects.requireNonNull(alias));
        return (T)((AbstractQuery)this.getSelf());
    }

    public T excludeFields(String ... fields) {
        if (this.excludeSelects == null) {
            this.excludeSelects = new HashSet<String>();
        }
        for (String field : fields) {
            this.excludeSelects.add(this.handleField(field));
        }
        return (T)((AbstractQuery)this.getSelf());
    }

    public T groupBy(String ... fields) {
        if (this.groupBys == null) {
            this.groupBys = new ArrayList<String>();
        }
        for (String field : fields) {
            this.groupBys.add(this.handleField(field));
        }
        return (T)((AbstractQuery)this.getSelf());
    }

    public T asc(String field) {
        return this.order(new OrderParam(field, false));
    }

    public T desc(String field) {
        return this.order(new OrderParam(field, true));
    }

    public T order(OrderParam orderParam) {
        if (this.orders == null) {
            this.orders = new ArrayList<OrderParam>();
        }
        orderParam.setField(this.handleField(orderParam.getField()));
        this.orders.add(orderParam);
        return (T)((AbstractQuery)this.getSelf());
    }

    public T having(Filter filter) {
        if (this.having == null) {
            this.having = new ArrayList<Filter>();
        }
        Objects.requireNonNull(filter, "\u8fc7\u6ee4\u5668\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.isSkipNullValueFilter() || this.isSkipNullValueFilter() && FilterUtils.hasFilter(filter)) {
            if (this.selectExpression != null && this.selectExpression.stream().map(Expression::getAlias).anyMatch(s -> s != null && s.equals(filter.getField()))) {
                this.having.add(filter);
            } else {
                this.having.add(this.handleFilter(filter));
            }
        }
        return (T)((AbstractQuery)this.getSelf());
    }

    public T union(AbstractQuery<T> unionQuery) {
        if (this.unions == null) {
            this.unions = new ArrayList<UnionQueryParam>();
        }
        this.unions.add(new UnionQueryParam(unionQuery, false));
        return (T)((AbstractQuery)this.getSelf());
    }

    public T unionAll(AbstractQuery<T> unionQuery) {
        if (this.unions == null) {
            this.unions = new ArrayList<UnionQueryParam>();
        }
        this.unions.add(new UnionQueryParam(unionQuery, true));
        return (T)((AbstractQuery)this.getSelf());
    }

    public T page(PageParam pageParam) {
        this.pageParam = pageParam;
        return (T)((AbstractQuery)this.getSelf());
    }

    public T page(int page, int size) {
        PageParam pageParam = ServiceLoaderUtils.loadOne(PageParam.class);
        if (pageParam != null) {
            this.pageParam = pageParam;
            this.pageParam.setPage(page);
            this.pageParam.setSize(size);
        } else {
            this.pageParam = new MysqlPage(page, size);
        }
        return (T)((AbstractQuery)this.getSelf());
    }

    protected abstract String handleField(String var1);

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public List<String> getSelects() {
        return this.selects;
    }

    public Map<String, String> getAliasMap() {
        return this.aliasMap;
    }

    public List<Expression> getSelectExpression() {
        return this.selectExpression;
    }

    public List<SubQueryParam> getSelectSubQueryList() {
        return this.selectSubQueryList;
    }

    public List<String> getGroupBys() {
        return this.groupBys;
    }

    public T setGroupBys(List<String> groupBys) {
        this.groupBys = groupBys;
        return (T)((AbstractQuery)this.getSelf());
    }

    public List<OrderParam> getOrders() {
        return this.orders;
    }

    public List<Filter> getHaving() {
        return this.having;
    }

    public List<UnionQueryParam> getUnions() {
        return this.unions;
    }

    public PageParam getPageParam() {
        return this.pageParam;
    }

    @Override
    public void check(Class<?> mainEntityClass) {
        if (this.selectAll && !this.checked) {
            Map<String, String> fieldColumns = FieldUtils.entityFieldColumns(this.getEntityClass() != null ? this.getEntityClass() : mainEntityClass);
            if (this.excludeSelects != null && this.excludeSelects.size() > 0) {
                fieldColumns.keySet().stream().map(this::handleField).filter(k -> !this.excludeSelects.contains(k)).forEach(this::select);
            } else {
                fieldColumns.keySet().stream().map(this::handleField).forEach(this::select);
            }
        }
        if (this.excludeSelects != null) {
            block0: for (String excludeSelect : this.excludeSelects) {
                for (int i = 0; i < this.selects.size(); ++i) {
                    if (!Objects.equals(excludeSelect, this.selects.get(i))) continue;
                    this.selects.remove(i);
                    continue block0;
                }
            }
        }
        super.check(mainEntityClass);
        if (this.selectSubQueryList != null) {
            for (SubQueryParam sub : this.selectSubQueryList) {
                sub.getQuery().check(mainEntityClass);
            }
        }
        AbstractQuery.checkFilter(mainEntityClass, this.having, false);
        if (this.unions != null) {
            for (UnionQueryParam union : this.unions) {
                union.getUnion().check(mainEntityClass);
            }
        }
    }

    public QuerySQL sqlValue() {
        return QuerySQL.build(this);
    }
}

