/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.query;

import cn.veasion.db.base.Expression;
import cn.veasion.db.base.Filter;
import cn.veasion.db.base.JoinType;
import cn.veasion.db.base.JoinTypeEnum;
import cn.veasion.db.base.Operator;
import cn.veasion.db.query.AbstractQuery;
import cn.veasion.db.query.JoinQueryParam;
import cn.veasion.db.utils.FilterUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractJoinQuery<T extends AbstractJoinQuery<?>>
extends AbstractQuery<T> {
    protected String tableAs;
    protected List<JoinQueryParam> joins;
    protected List<JoinQueryParam> relations;

    public JoinQueryParam join(AbstractJoinQuery<?> entityQuery) {
        return this.join(JoinTypeEnum.JOIN, entityQuery);
    }

    public JoinQueryParam leftJoin(AbstractJoinQuery<?> entityQuery) {
        return this.join(JoinTypeEnum.LEFT_JOIN, entityQuery);
    }

    public JoinQueryParam rightJoin(AbstractJoinQuery<?> entityQuery) {
        return this.join(JoinTypeEnum.RIGHT_JOIN, entityQuery);
    }

    public JoinQueryParam fullJoin(AbstractJoinQuery<?> entityQuery) {
        return this.join(JoinTypeEnum.FULL_JOIN, entityQuery);
    }

    public JoinQueryParam join(JoinType joinType, AbstractJoinQuery<?> entityQuery) {
        if (this.joins == null) {
            this.joins = new ArrayList<JoinQueryParam>();
        }
        JoinQueryParam joinQueryParam = new JoinQueryParam(this, joinType, entityQuery);
        this.joins.add(joinQueryParam);
        return joinQueryParam;
    }

    @Override
    public T selectExpression(Expression expression) {
        if (expression == null) {
            return (T)((AbstractJoinQuery)this.getSelf());
        }
        return (T)((AbstractJoinQuery)super.selectExpression(expression.tableAs(this.tableAs)));
    }

    @Override
    public T filterExpression(String field, Operator operator, Expression expression) {
        return (T)((AbstractJoinQuery)super.filterExpression(field, operator, expression.tableAs(this.tableAs)));
    }

    @Override
    protected String handleField(String field) {
        return FilterUtils.tableAsField(this.tableAs, field);
    }

    @Override
    protected Filter handleFilter(Filter filter) {
        return filter.fieldAs(this.tableAs);
    }

    @Override
    public void check(Class<?> mainEntityClass) {
        if (this.joins != null) {
            this.relations = new ArrayList<JoinQueryParam>();
        }
        this.check(mainEntityClass, this, true);
    }

    protected void check(Class<?> mainEntityClass, AbstractJoinQuery<?> mainQuery, boolean isMain) {
        if (isMain && mainQuery.isAllEmptySelects()) {
            this.selectAll();
        }
        super.check(mainEntityClass);
        if (this.joins != null) {
            for (JoinQueryParam join : this.joins) {
                if (!isMain) {
                    mainQuery.relations.add(join);
                }
                join.getJoinQuery().check(mainEntityClass, mainQuery, false);
            }
        }
    }

    protected boolean isAllEmptySelects() {
        boolean emptySelects = this.isEmptySelects();
        if (emptySelects && this.joins != null) {
            for (JoinQueryParam join : this.joins) {
                if (join.getJoinQuery().isAllEmptySelects()) continue;
                emptySelects = false;
                break;
            }
        }
        return emptySelects;
    }

    public String getTableAs() {
        return this.tableAs;
    }

    public List<JoinQueryParam> getJoins() {
        return this.joins;
    }

    public List<JoinQueryParam> getJoinAll() {
        if (this.joins == null || this.relations == null) {
            return this.joins;
        }
        ArrayList<JoinQueryParam> joinList = new ArrayList<JoinQueryParam>(this.joins.size() + this.relations.size());
        joinList.addAll(this.joins);
        joinList.addAll(this.relations);
        return joinList;
    }

    protected abstract boolean isEmptySelects();
}

