/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.parser;

import cn.veasion.db.DbException;
import cn.veasion.db.parser.DbFromItemVisitor;
import cn.veasion.db.parser.DbStatementVisitor;
import cn.veasion.db.utils.FieldUtils;
import java.io.Reader;
import java.io.StringReader;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;

public class SQLParseUtils {
    public static String parseSQLConvert(String sql) {
        try {
            CCJSqlParserManager parser = new CCJSqlParserManager();
            Statement statement = parser.parse((Reader)new StringReader(sql));
            DbStatementVisitor dbStatementVisitor = new DbStatementVisitor();
            statement.accept((StatementVisitor)dbStatementVisitor);
            String string = dbStatementVisitor.toString();
            return string;
        }
        catch (Exception e) {
            throw new DbException("sql\u89e3\u6790\u5f02\u5e38", e);
        }
        catch (NoClassDefFoundError t) {
            throw new DbException("jsqlparser maven \u4f5c\u7528\u57df\u4e3a provided \u8bf7\u624b\u52a8\u52a0\u5165\u8be5 jar \u4f9d\u8d56", t);
        }
        finally {
            DbFromItemVisitor.NAME_INDEX.remove();
        }
    }

    static String getTableClass(String table) {
        return FieldUtils.firstCase(FieldUtils.lineToHump(SQLParseUtils.getSimpleTable(table)), false) + "PO.class";
    }

    static String getByTable(Table table) {
        return SQLParseUtils.getTableClass(table.getName()).replace(".class", "");
    }

    static String getVarByTable(Table table) {
        Alias alias = table.getAlias();
        if (alias != null && alias.getName() != null) {
            return alias.getName();
        }
        return SQLParseUtils.getSimpleTable(table.getName());
    }

    static String getSimpleTable(String table) {
        if ((table = SQLParseUtils.sqlTrim(table)).length() > 1 && table.charAt(1) == '_') {
            table = table.substring(2);
        }
        return table;
    }

    static String getColumnField(String var, Column column) {
        String _var;
        String f = SQLParseUtils.columnToField(column.getColumnName());
        if (column.getTable() != null && !"".equals(column.getTable().toString()) && !(_var = SQLParseUtils.getVarByTable(column.getTable())).equals(var) && column.getTable() != null) {
            f = column.getTable().toString() + "." + f;
        }
        return f;
    }

    static String columnToField(String s) {
        return FieldUtils.lineToHump(SQLParseUtils.sqlTrim(s));
    }

    static String sqlTrim(String s) {
        if (s.startsWith("`") && s.endsWith("`") || s.startsWith("'") && s.endsWith("'") || s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

