/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.parser;

import cn.veasion.db.parser.DbExpressionVisitor;
import cn.veasion.db.parser.DbSelectVisitor;
import cn.veasion.db.parser.SQLParseUtils;
import cn.veasion.db.utils.FieldUtils;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.StatementVisitorAdapter;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.update.Update;

public class DbStatementVisitor
extends StatementVisitorAdapter {
    StringBuilder sb = new StringBuilder();

    public void visit(Insert insert) {
        Table table = insert.getTable();
        List columns = insert.getColumns();
        ItemsList itemsList = insert.getItemsList();
        Select select = insert.getSelect();
        String var = SQLParseUtils.getVarByTable(table);
        if (select != null) {
            DbSelectVisitor selectVisitor = new DbSelectVisitor();
            select.getSelectBody().accept((SelectVisitor)selectVisitor);
            this.sb.append("\r\n// \u67e5\u8be2\u5b57\u6bb5\u6216\u522b\u540d\u4f1a\u81ea\u52a8\u5bf9\u5e94\u65b0\u589e\u5b57\u6bb5\uff0c\u5982\u679c\u67e5\u8be2\u5b57\u6bb5\u8ddf\u65b0\u589e\u5b57\u6bb5\u4e0d\u4e00\u81f4\u8bf7\u52a0\u522b\u540d\u5373\u53ef");
            this.sb.append((CharSequence)selectVisitor.sb);
            this.sb.append("\r\n");
            this.sb.append("BatchEntityInsert batchInsert = new BatchEntityInsert(").append(selectVisitor.var).append(");");
        } else {
            String entity = SQLParseUtils.getByTable(table);
            this.sb.append(entity).append(" ").append(var);
            this.sb.append(" = new ").append(entity).append("();\r\n");
            if (columns != null && !columns.isEmpty()) {
                for (Column column : columns) {
                    String fieldSetter = FieldUtils.firstCase(SQLParseUtils.columnToField(column.getColumnName()), false);
                    this.sb.append(var).append(".set").append(fieldSetter).append("(null);\r\n");
                }
            }
            this.sb.append("\r\n");
            if (itemsList instanceof MultiExpressionList) {
                this.sb.append("List<").append(entity);
                this.sb.append("> list = new ArrayList<>();\r\n");
                this.sb.append("list.add(").append(var).append(");\r\n");
                this.sb.append("BatchEntityInsert batchInsert = new BatchEntityInsert(list);");
            } else {
                this.sb.append("EntityInsert insert = new EntityInsert(").append(var).append(");");
            }
        }
    }

    public void visit(Delete delete) {
        if (delete.getJoins() != null) {
            this.sb.append("// \u5220\u9664\u6682\u4e0d\u652f\u6301join\r\n");
        }
        this.sb.append("Delete delete = new Delete();\r\n");
        Expression where = delete.getWhere();
        if (where != null) {
            DbExpressionVisitor expressionVisitor = new DbExpressionVisitor();
            expressionVisitor.var = "delete";
            where.accept((ExpressionVisitor)expressionVisitor);
            this.sb.append((CharSequence)expressionVisitor.sb);
        }
        this.sb.append("\r\ndelete.setEntityClass(");
        this.sb.append(SQLParseUtils.getTableClass(delete.getTable().getName())).append(")\r\n");
    }

    public void visit(Update update) {
        Expression where;
        int i;
        List tables = update.getTables();
        ArrayList<String> varList = new ArrayList<String>();
        for (Table table : tables) {
            String var = SQLParseUtils.getVarByTable(table);
            varList.add(var);
            this.sb.append("EU ").append(var);
            this.sb.append(" = new EU(").append(SQLParseUtils.getTableClass(table.getName()));
            Alias alias = table.getAlias();
            if (alias != null && alias.getName() != null) {
                this.sb.append(", \"").append(SQLParseUtils.sqlTrim(alias.getName())).append("\"");
            }
            this.sb.append(");\r\n");
        }
        this.sb.append("\r\n");
        String var = (String)varList.get(0);
        List columns = update.getColumns();
        List expressions = update.getExpressions();
        if (columns != null && !columns.isEmpty()) {
            DbExpressionVisitor expressionVisitor = new DbExpressionVisitor();
            for (i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                String field = SQLParseUtils.getColumnField(var, column);
                Expression expression = (Expression)expressions.get(i);
                if (expression instanceof Function || expression instanceof Column) {
                    this.sb.append(var).append(".updateExpression(\"").append(field).append("\", ");
                    this.sb.append("\"").append(expression.toString()).append("\"");
                } else {
                    this.sb.append(var).append(".update(\"").append(field).append("\", ");
                    expressionVisitor.var = var;
                    expressionVisitor.sb = this.sb;
                    expression.accept((ExpressionVisitor)expressionVisitor);
                }
                this.sb.append(");\r\n");
            }
        }
        if ((where = update.getWhere()) != null) {
            DbExpressionVisitor expressionVisitor = new DbExpressionVisitor();
            expressionVisitor.var = var;
            where.accept((ExpressionVisitor)expressionVisitor);
            this.sb.append((CharSequence)expressionVisitor.sb);
        }
        this.sb.append("\r\n");
        for (i = 1; i < tables.size(); ++i) {
            this.sb.append(var).append(".join(").append((String)varList.get(i)).append(");\r\n");
        }
    }

    public void visit(Select select) {
        DbSelectVisitor selectVisitor = new DbSelectVisitor();
        select.getSelectBody().accept((SelectVisitor)selectVisitor);
        this.sb.append(selectVisitor.toString());
    }

    public String toString() {
        return this.sb.length() == 0 ? "\u6682\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\u8f6c\u6362" : this.sb.toString();
    }
}

