/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.parser;

import cn.veasion.db.parser.DbExpressionVisitor;
import cn.veasion.db.parser.DbFromItemVisitor;
import cn.veasion.db.parser.SQLParseUtils;
import cn.veasion.db.parser.SubSelectVisitor;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperation;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.UnionOp;
import net.sf.jsqlparser.statement.select.WithItem;

public class DbSelectVisitor
implements SelectVisitor {
    String var;
    StringBuilder sb = new StringBuilder();

    public void visit(PlainSelect plainSelect) {
        Expression having;
        List groups;
        FromItem fromItem = plainSelect.getFromItem();
        DbFromItemVisitor dbFromItemVisitor = new DbFromItemVisitor();
        fromItem.accept((FromItemVisitor)dbFromItemVisitor);
        this.var = dbFromItemVisitor.var;
        this.sb.append((CharSequence)dbFromItemVisitor.sb);
        this.joins(plainSelect.getJoins());
        if (plainSelect.getDistinct() != null) {
            this.sb.append(this.var);
            this.appendLine(".distinct();");
        }
        this.handleSelectItems(this.var, plainSelect.getSelectItems());
        Expression where = plainSelect.getWhere();
        if (where != null) {
            DbExpressionVisitor expressionVisitor = new DbExpressionVisitor();
            expressionVisitor.var = this.var;
            expressionVisitor.master = this.sb;
            where.accept((ExpressionVisitor)expressionVisitor);
            this.sb.append((CharSequence)expressionVisitor.sb);
        }
        if ((groups = plainSelect.getGroupByColumnReferences()) != null && !groups.isEmpty()) {
            this.sb.append(this.var).append(".groupBy(");
            int len = this.sb.length();
            for (Expression group : groups) {
                if (!(group instanceof Column)) continue;
                String columnField = SQLParseUtils.getColumnField(this.var, (Column)group);
                this.sb.append("\"").append(columnField).append("\"").append(", ");
            }
            if (this.sb.length() > len) {
                this.sb.setLength(this.sb.length() - 2);
            }
            this.sb.append(");\r\n");
        }
        if ((having = plainSelect.getHaving()) != null) {
            DbExpressionVisitor expressionVisitor = new DbExpressionVisitor();
            expressionVisitor.var = this.var;
            expressionVisitor.master = this.sb;
            expressionVisitor.havingFilter = true;
            having.accept((ExpressionVisitor)expressionVisitor);
            this.sb.append((CharSequence)expressionVisitor.sb);
        }
        this.orderBy(this.sb, this.var, plainSelect.getOrderByElements());
        this.limit(this.sb, this.var, plainSelect.getLimit());
    }

    private void joins(List<Join> joins) {
        if (joins == null || joins.isEmpty()) {
            return;
        }
        for (Join join : joins) {
            FromItem rightItem = join.getRightItem();
            Expression onExpression = join.getOnExpression();
            DbFromItemVisitor joinFromItemVisitor = new DbFromItemVisitor();
            rightItem.accept((FromItemVisitor)joinFromItemVisitor);
            this.sb.append((CharSequence)joinFromItemVisitor.sb);
            String joinType = "join";
            if (join.isLeft()) {
                joinType = "leftJoin";
            } else if (join.isRight()) {
                joinType = "rightJoin";
            } else if (join.isFull()) {
                joinType = "fullJoin";
            }
            this.sb.append(this.var).append(".").append(joinType).append("(").append(joinFromItemVisitor.var).append(")");
            if (onExpression != null) {
                DbExpressionVisitor expressionVisitor = new DbExpressionVisitor();
                expressionVisitor.master = this.sb;
                expressionVisitor.onFilter = true;
                expressionVisitor.joinVar = joinFromItemVisitor.var;
                expressionVisitor.joinUseMainVar = this.var;
                onExpression.accept((ExpressionVisitor)expressionVisitor);
                this.sb.append((CharSequence)expressionVisitor.sb);
            }
            this.sb.append(";\r\n");
        }
    }

    private void orderBy(StringBuilder sb, String var, List<OrderByElement> orders) {
        if (orders != null && !orders.isEmpty()) {
            for (OrderByElement order : orders) {
                Expression expression = order.getExpression();
                if (!(expression instanceof Column)) continue;
                if (order.isAsc()) {
                    sb.append(var).append(".asc(");
                } else {
                    sb.append(var).append(".desc(");
                }
                sb.append("\"").append(SQLParseUtils.getColumnField(var, (Column)expression)).append("\"");
                sb.append(");\r\n");
            }
        }
    }

    private void limit(StringBuilder sb, String var, Limit limit) {
        if (limit == null) {
            return;
        }
        Expression offset = limit.getOffset();
        Expression rowCount = limit.getRowCount();
        if (rowCount instanceof LongValue && (offset == null || offset instanceof LongValue)) {
            long size = ((LongValue)rowCount).getValue();
            sb.append(var).append(".page(");
            if (offset == null) {
                sb.append("1");
            } else {
                sb.append((int)(size / ((LongValue)offset).getValue()));
            }
            sb.append(", ");
            sb.append(size);
            sb.append(");\r\n");
        } else {
            sb.append("// \u5206\u9875\u793a\u4f8b\r\n");
            sb.append("// ").append(var).append(".page(1, 10);\r\n");
        }
    }

    private void handleSelectItems(final String var, List<SelectItem> selectItems) {
        if (selectItems == null || selectItems.isEmpty()) {
            return;
        }
        SelectItemVisitor itemVisitor = new SelectItemVisitor(){

            public void visit(AllColumns allColumns) {
                DbSelectVisitor.this.sb.append(var).append(".selectAll();");
                DbSelectVisitor.this.appendLine();
            }

            public void visit(AllTableColumns allTableColumns) {
                String _var = var;
                Table table = allTableColumns.getTable();
                if (table != null && !"".equals(table.toString())) {
                    _var = SQLParseUtils.getVarByTable(table);
                }
                DbSelectVisitor.this.sb.append(_var).append(".selectAll();");
                DbSelectVisitor.this.appendLine();
            }

            public void visit(SelectExpressionItem selectExpressionItem) {
                String _var = var;
                Expression expression = selectExpressionItem.getExpression();
                Alias alias = selectExpressionItem.getAlias();
                String as = null;
                if (alias != null && alias.getName() != null) {
                    as = SQLParseUtils.sqlTrim(alias.getName().replace(" AS ", "").trim());
                }
                if (expression instanceof Column) {
                    Table table = ((Column)expression).getTable();
                    if (table != null && !"".equals(table.toString())) {
                        _var = SQLParseUtils.getVarByTable(table);
                    }
                    String columnName = ((Column)expression).getColumnName();
                    DbSelectVisitor.this.sb.append(_var).append(".select(\"").append(SQLParseUtils.columnToField(columnName)).append("\"");
                } else if (expression instanceof Function) {
                    DbSelectVisitor.this.sb.append(_var).append(".selectExpression(\"").append(expression.toString()).append("\"");
                    if (alias == null || alias.getName() == null) {
                        DbSelectVisitor.this.sb.append(", null");
                    }
                } else if (expression instanceof SubSelect) {
                    String subVar = SubSelectVisitor.visit(DbSelectVisitor.this.sb, (SubSelect)expression, as);
                    DbSelectVisitor.this.sb.append(_var).append(".selectSubQuery(SubQueryParam.build(").append(subVar).append(")");
                } else {
                    DbSelectVisitor.this.sb.append(_var).append(".select(\"").append(expression.toString()).append("\"");
                }
                if (as != null && !(expression instanceof SubSelect)) {
                    DbSelectVisitor.this.sb.append(", \"").append(as).append("\"");
                }
                DbSelectVisitor.this.appendLine(");");
            }
        };
        for (SelectItem selectItem : selectItems) {
            selectItem.accept(itemVisitor);
        }
    }

    public void visit(SetOperationList setOperationList) {
        List operations;
        List selects = setOperationList.getSelects();
        ArrayList<String> _vars = new ArrayList<String>();
        if (selects != null && !selects.isEmpty()) {
            for (SelectBody select : selects) {
                DbSelectVisitor selectVisitor = new DbSelectVisitor();
                select.accept((SelectVisitor)selectVisitor);
                this.sb.append((CharSequence)selectVisitor.sb);
                _vars.add(selectVisitor.var);
            }
            this.var = (String)_vars.get(0);
        }
        if ((operations = setOperationList.getOperations()) != null && !operations.isEmpty()) {
            int index = 1;
            this.sb.append("\r\n");
            for (SetOperation operation : operations) {
                if (!(operation instanceof UnionOp)) continue;
                boolean all = ((UnionOp)operation).isAll();
                this.sb.append(this.var).append(all ? ".unionAll(" : ".union(").append((String)_vars.get(index++)).append(");\r\n");
            }
        }
        this.orderBy(this.sb, this.var, setOperationList.getOrderByElements());
        this.limit(this.sb, this.var, setOperationList.getLimit());
    }

    public void visit(WithItem withItem) {
    }

    private void appendLine() {
        this.sb.append("\r\n");
    }

    private void appendLine(String s) {
        this.sb.append(s).append("\r\n");
    }

    public String toString() {
        return this.sb.toString();
    }
}

