/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.parser;

import cn.veasion.db.parser.SQLParseUtils;
import cn.veasion.db.parser.SubSelectVisitor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.ValuesList;

public class DbFromItemVisitor
implements FromItemVisitor {
    Table table;
    String var;
    String tableName;
    boolean isSubQuery;
    StringBuilder sb = new StringBuilder();
    public static final ThreadLocal<Map<String, AtomicInteger>> NAME_INDEX = ThreadLocal.withInitial(ConcurrentHashMap::new);

    public void visit(Table table) {
        this.table = table;
        this.tableName = SQLParseUtils.sqlTrim(table.getName());
        String tableAs = table.getAlias() != null ? table.getAlias().getName() : null;
        this.var = SQLParseUtils.getVarByTable(table);
        if (this.var == null) {
            this.var = tableAs;
        }
        this.var = this.checkVar(this.var);
        this.sb.append("\r\n");
        this.sb.append("EQ ").append(this.var).append(" = new EQ(");
        this.sb.append(SQLParseUtils.getTableClass(this.tableName));
        if (tableAs != null) {
            this.sb.append(", \"").append(tableAs).append("\"");
        }
        this.sb.append(");\r\n");
    }

    public void visit(SubSelect subSelect) {
        this.isSubQuery = true;
        this.var = this.checkVar(subSelect.getAlias().getName());
        String subVar = SubSelectVisitor.visit(this.sb, subSelect);
        this.sb.append("\r\n");
        this.sb.append("SubQuery ").append(this.var).append(" = new SubQuery(");
        this.sb.append(subVar).append(", \"").append(subSelect.getAlias().getName()).append("\");\r\n");
    }

    private String checkVar(String var) {
        Map<String, AtomicInteger> map = NAME_INDEX.get();
        AtomicInteger value = map.compute(var, (k, v) -> {
            if (v == null) {
                v = new AtomicInteger(0);
            } else {
                v.incrementAndGet();
            }
            return v;
        });
        if (value.get() == 0) {
            return var;
        }
        return var + value.get();
    }

    public void visit(SubJoin subJoin) {
        System.out.println("subJoin: " + subJoin);
    }

    public void visit(LateralSubSelect lateralSubSelect) {
        System.out.println("lateralSubSelect: " + lateralSubSelect);
    }

    public void visit(ValuesList valuesList) {
        System.out.println("valuesList: " + valuesList);
    }

    public void visit(TableFunction tableFunction) {
        System.out.println("tableFunction: " + tableFunction);
    }

    public void visit(ParenthesisFromItem parenthesisFromItem) {
        System.out.println("parenthesisFromItem: " + parenthesisFromItem);
    }

    public String toString() {
        return this.sb.toString();
    }
}

