/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.parser;

import cn.veasion.db.parser.SQLParseUtils;
import cn.veasion.db.parser.SubSelectVisitor;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.JsonExpression;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.ValueListExpression;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseRightShift;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.SubSelect;

public class DbExpressionVisitor
implements ExpressionVisitor {
    String var;
    boolean onFilter;
    boolean havingFilter;
    String joinUseMainVar;
    String joinVar;
    StringBuilder master = new StringBuilder();
    StringBuilder sb = new StringBuilder();

    public void visit(BitwiseRightShift bitwiseRightShift) {
        this.sb.append(bitwiseRightShift.toString());
    }

    public void visit(BitwiseLeftShift bitwiseLeftShift) {
        this.sb.append(bitwiseLeftShift.toString());
    }

    public void visit(NullValue nullValue) {
        this.sb.append(nullValue.toString());
    }

    public void visit(Function function) {
        this.sb.append("\"").append(function.toString()).append("\"");
    }

    public void visit(SignedExpression signedExpression) {
        this.sb.append(signedExpression.toString());
    }

    public void visit(JdbcParameter jdbcParameter) {
    }

    public void visit(JdbcNamedParameter jdbcNamedParameter) {
    }

    public void visit(DoubleValue doubleValue) {
        this.sb.append(doubleValue.toString());
    }

    public void visit(LongValue longValue) {
        this.sb.append(longValue.toString());
    }

    public void visit(HexValue hexValue) {
        this.sb.append("\"").append(hexValue.toString()).append("\"");
    }

    public void visit(DateValue dateValue) {
        this.sb.append("new Date()");
    }

    public void visit(TimeValue timeValue) {
        this.sb.append("new Date()");
    }

    public void visit(TimestampValue timestampValue) {
        this.sb.append("new Date()");
    }

    public void visit(Parenthesis parenthesis) {
        this.appendVarFunFilterByType("leftBracket()", true);
        parenthesis.getExpression().accept((ExpressionVisitor)this);
        this.appendVarFunFilterByType("rightBracket()", true);
    }

    public void visit(StringValue stringValue) {
        this.sb.append("\"").append(stringValue.getValue()).append("\"");
    }

    public void visit(Addition addition) {
        addition.getLeftExpression().accept((ExpressionVisitor)this);
        this.sb.append(" + ");
        addition.getRightExpression().accept((ExpressionVisitor)this);
    }

    public void visit(Division division) {
        division.getLeftExpression().accept((ExpressionVisitor)this);
        this.sb.append(" / ");
        division.getRightExpression().accept((ExpressionVisitor)this);
    }

    public void visit(Multiplication multiplication) {
        multiplication.getLeftExpression().accept((ExpressionVisitor)this);
        this.sb.append(" * ");
        multiplication.getRightExpression().accept((ExpressionVisitor)this);
    }

    public void visit(Subtraction subtraction) {
        subtraction.getLeftExpression().accept((ExpressionVisitor)this);
        this.sb.append(" - ");
        subtraction.getRightExpression().accept((ExpressionVisitor)this);
    }

    public void visit(AndExpression andExpression) {
        if (andExpression.getLeftExpression() != null) {
            andExpression.getLeftExpression().accept((ExpressionVisitor)this);
        }
        if (andExpression.getRightExpression() != null) {
            andExpression.getRightExpression().accept((ExpressionVisitor)this);
        }
    }

    public void visit(OrExpression orExpression) {
        if (orExpression.getLeftExpression() != null) {
            orExpression.getLeftExpression().accept((ExpressionVisitor)this);
        }
        this.appendVarFunFilterByType("or()", true);
        if (orExpression.getRightExpression() != null) {
            orExpression.getRightExpression().accept((ExpressionVisitor)this);
        }
    }

    public void visit(Between between) {
        if (this.havingFilter) {
            this.appendVarFun("having(Filter.between(", false);
        } else if (this.onFilter) {
            this.appendVarFun("on(Filter.between(", false);
        } else {
            this.appendVarFun("between(", false);
        }
        between.getLeftExpression().accept((ExpressionVisitor)this);
        this.sb.append(", ");
        between.getBetweenExpressionStart().accept((ExpressionVisitor)this);
        this.sb.append(", ");
        between.getBetweenExpressionEnd().accept((ExpressionVisitor)this);
        if (this.havingFilter || this.onFilter) {
            this.sb.append(")");
        }
        this.sb.append(")");
        if (!this.onFilter) {
            this.sb.append(";\r\n");
        }
    }

    public void visit(EqualsTo equalsTo) {
        Expression leftExpression = equalsTo.getLeftExpression();
        Expression rightExpression = equalsTo.getRightExpression();
        if (this.onFilter && leftExpression instanceof Column && rightExpression instanceof Column) {
            this.sb.append(".on(\"").append(SQLParseUtils.getColumnField(this.joinUseMainVar, (Column)leftExpression));
            this.sb.append("\", \"").append(SQLParseUtils.getColumnField(this.joinVar, (Column)rightExpression));
            this.sb.append("\")");
        } else {
            this.handleComparisonOperator((ComparisonOperator)equalsTo, "eq");
        }
    }

    public void visit(GreaterThan greaterThan) {
        this.handleComparisonOperator((ComparisonOperator)greaterThan, "gt");
    }

    public void visit(GreaterThanEquals greaterThanEquals) {
        this.handleComparisonOperator((ComparisonOperator)greaterThanEquals, "gte");
    }

    public void visit(InExpression inExpression) {
        Expression leftExpression = inExpression.getLeftExpression();
        ItemsList rightItemsList = inExpression.getRightItemsList();
        boolean subQuery = rightItemsList instanceof SubSelect;
        boolean leftColumn = leftExpression instanceof Column;
        if (leftColumn) {
            String column = SQLParseUtils.getColumnField(this.var, (Column)leftExpression);
            column = "\"" + column + "\"";
            String s = (subQuery ? "subQuery(" : (inExpression.isNot() ? "notIn(" : "in(")) + column;
            if (this.havingFilter) {
                this.appendVarFun("having(Filter." + s, false);
            } else if (this.onFilter) {
                this.appendVarFun("on(Filter." + s, false);
            } else {
                if (subQuery) {
                    s = "filterSubQuery(" + column;
                }
                this.appendVarFun(s, false);
            }
            if (subQuery) {
                this.sb.append(", Operator.").append(inExpression.isNot() ? "NOT_IN" : "IN");
            }
            this.sb.append(", ");
            if (rightItemsList instanceof ExpressionList) {
                String list = rightItemsList.toString();
                if (list.startsWith("(") && list.endsWith(")")) {
                    this.sb.append("Arrays.asList").append(list);
                } else {
                    this.sb.append("new Object[]{}");
                }
            } else if (subQuery) {
                SubSelect subSelect = (SubSelect)rightItemsList;
                String _var = SubSelectVisitor.visit(this.master, subSelect);
                this.sb.append("SubQueryParam.build(").append(_var).append(")");
            }
            if (this.havingFilter || this.onFilter) {
                this.sb.append(")");
            }
            this.sb.append(")");
            if (!this.onFilter) {
                this.sb.append(";\r\n");
            }
        }
    }

    public void visit(IsNullExpression isNullExpression) {
        this.leftRight(isNullExpression.getLeftExpression(), isNullExpression.isNot() ? "isNotNull" : "isNull", null);
    }

    public void visit(LikeExpression likeExpression) {
        if (!likeExpression.isNot()) {
            Expression leftExpression = likeExpression.getLeftExpression();
            Expression rightExpression = likeExpression.getRightExpression();
            String opt = "like";
            if (rightExpression instanceof StringValue) {
                String value = ((StringValue)rightExpression).getValue().trim();
                if (value.startsWith("%") && value.endsWith("%")) {
                    opt = "like";
                    value = value.substring(1, value.length() - 1);
                } else if (value.startsWith("%")) {
                    opt = "likeLeft";
                    value = value.substring(1);
                } else if (value.endsWith("%")) {
                    opt = "likeRight";
                    value = value.substring(0, value.length() - 1);
                }
                ((StringValue)rightExpression).setValue(value);
            }
            this.leftRight(leftExpression, opt, rightExpression);
        }
    }

    public void visit(MinorThan minorThan) {
        this.handleComparisonOperator((ComparisonOperator)minorThan, "lt");
    }

    public void visit(MinorThanEquals minorThanEquals) {
        this.handleComparisonOperator((ComparisonOperator)minorThanEquals, "lte");
    }

    public void visit(NotEqualsTo notEqualsTo) {
        this.handleComparisonOperator((ComparisonOperator)notEqualsTo, "neq");
    }

    public void visit(Column column) {
        this.sb.append("\"").append(SQLParseUtils.getColumnField(this.var, column)).append("\"");
    }

    public void visit(SubSelect subSelect) {
        String _var = SubSelectVisitor.visit(this.master, subSelect);
        this.sb.append("SubQueryParam.build(").append(_var).append(")");
    }

    public void visit(CaseExpression caseExpression) {
        if (!this.havingFilter && !this.onFilter) {
            this.appendVarFun("selectExpression(\"" + caseExpression.toString() + "\", null);", true);
        }
    }

    public void visit(WhenClause whenClause) {
        if (!this.havingFilter && !this.onFilter) {
            this.appendVarFun("selectExpression(\"" + whenClause.toString() + "\", null);", true);
        }
    }

    public void visit(ExistsExpression existsExpression) {
        if ((this.onFilter || this.havingFilter) && existsExpression.getRightExpression() instanceof SubSelect) {
            this.appendVarFunFilterByType("subQuery(null, Operator." + (existsExpression.isNot() ? "NOT_" : "") + "EXISTS, ", false);
        } else {
            if (existsExpression.isNot()) {
                this.appendVarFun("notExists(", false);
            } else {
                this.appendVarFun("exists(", false);
            }
            existsExpression.getRightExpression().accept((ExpressionVisitor)this);
        }
        this.sb.append(")");
        if (!this.onFilter) {
            this.sb.append(";\r\n");
        }
    }

    public void visit(AllComparisonExpression allComparisonExpression) {
    }

    public void visit(AnyComparisonExpression anyComparisonExpression) {
    }

    public void visit(Concat concat) {
        this.sb.append(concat.toString());
    }

    public void visit(Matches matches) {
        this.sb.append(matches.toString());
    }

    public void visit(BitwiseAnd bitwiseAnd) {
        this.sb.append(bitwiseAnd.toString());
    }

    public void visit(BitwiseOr bitwiseOr) {
        this.sb.append(bitwiseOr.toString());
    }

    public void visit(BitwiseXor bitwiseXor) {
        this.sb.append(bitwiseXor.toString());
    }

    public void visit(CastExpression castExpression) {
    }

    public void visit(Modulo modulo) {
        modulo.getLeftExpression().accept((ExpressionVisitor)this);
        this.sb.append(" % ");
        modulo.getRightExpression().accept((ExpressionVisitor)this);
    }

    public void visit(AnalyticExpression analyticExpression) {
    }

    public void visit(ExtractExpression extractExpression) {
    }

    public void visit(IntervalExpression intervalExpression) {
        this.sb.append(intervalExpression.toString());
    }

    public void visit(OracleHierarchicalExpression oracleHierarchicalExpression) {
    }

    public void visit(RegExpMatchOperator regExpMatchOperator) {
        this.sb.append(regExpMatchOperator.toString());
    }

    public void visit(JsonExpression jsonExpression) {
    }

    public void visit(JsonOperator jsonOperator) {
    }

    public void visit(RegExpMySQLOperator regExpMySQLOperator) {
        this.sb.append(regExpMySQLOperator.toString());
    }

    public void visit(UserVariable userVariable) {
        this.sb.append(userVariable.toString());
    }

    public void visit(NumericBind numericBind) {
    }

    public void visit(KeepExpression keepExpression) {
    }

    public void visit(MySQLGroupConcat mySQLGroupConcat) {
        this.sb.append(mySQLGroupConcat.toString());
    }

    public void visit(ValueListExpression valueListExpression) {
        this.sb.append("new Object[]{}");
    }

    public void visit(RowConstructor rowConstructor) {
    }

    public void visit(OracleHint oracleHint) {
    }

    public void visit(TimeKeyExpression timeKeyExpression) {
        this.sb.append("\"").append(timeKeyExpression.toString()).append("\"");
    }

    public void visit(DateTimeLiteralExpression dateTimeLiteralExpression) {
    }

    public void visit(NotExpression notExpression) {
        this.sb.append("not");
        Expression expression = notExpression.getExpression();
        if (expression != null) {
            expression.accept((ExpressionVisitor)this);
        }
    }

    private void appendVarFunFilterByType(String s, boolean line) {
        if (this.havingFilter) {
            this.appendVarFun("having(Filter." + s + ");", line);
        } else if (this.onFilter) {
            this.appendVarFun("on(Filter." + s + ");", line);
        } else {
            this.appendVarFun(s + ";", line);
        }
    }

    private void appendVarFun(String s, boolean line) {
        if (s.startsWith("on(")) {
            this.sb.append(".").append(s);
        } else {
            this.sb.append(this.var).append(".").append(s);
            if (line) {
                this.sb.append("\r\n");
            }
        }
    }

    private void handleComparisonOperator(ComparisonOperator operator, String opt) {
        Expression leftExpression = operator.getLeftExpression();
        Expression rightExpression = operator.getRightExpression();
        this.leftRight(leftExpression, opt, rightExpression);
    }

    private void leftRight(Expression leftExpression, String opt, Expression rightExpression) {
        boolean expression;
        boolean leftColumn = leftExpression instanceof Column;
        boolean rightColumn = rightExpression instanceof Column;
        boolean bl = expression = leftColumn && (rightColumn || rightExpression instanceof Function);
        if (this.havingFilter) {
            this.appendVarFun("having(Filter." + (expression ? "expression(" : ""), false);
        } else if (this.onFilter) {
            this.appendVarFun("on(Filter." + (expression ? "expression(" : ""), false);
        } else {
            this.appendVarFun(expression ? "filterExpression(" : "", false);
        }
        if (!expression) {
            this.sb.append(opt).append("(");
        }
        leftExpression.accept((ExpressionVisitor)this);
        if (expression) {
            this.sb.append(", Operator.").append(opt.toUpperCase());
        }
        if (rightExpression != null) {
            this.sb.append(", ");
            rightExpression.accept((ExpressionVisitor)this);
        }
        if (this.havingFilter || this.onFilter) {
            this.sb.append(")");
        }
        this.sb.append(")");
        if (!this.onFilter) {
            this.sb.append(";\r\n");
        }
    }
}

