/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.jdbc;

import cn.veasion.db.DbException;
import cn.veasion.db.base.Expression;
import cn.veasion.db.base.Filter;
import cn.veasion.db.jdbc.AbstractSQL;
import cn.veasion.db.update.AbstractUpdate;
import cn.veasion.db.update.EntityUpdate;
import cn.veasion.db.update.JoinUpdateParam;
import cn.veasion.db.utils.FieldUtils;
import cn.veasion.db.utils.LeftRight;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateSQL
extends AbstractSQL<UpdateSQL> {
    protected AbstractUpdate<?> update;
    private List<JoinUpdateParam> joins;
    private Map<String, Object> tableEntityMap;

    public UpdateSQL(AbstractUpdate<?> update) {
        this.update = update;
    }

    public static UpdateSQL build(AbstractUpdate<?> update) {
        return new UpdateSQL(update).build();
    }

    @Override
    public UpdateSQL build() {
        this.reset();
        this.buildUpdate();
        return this;
    }

    public void buildUpdate() {
        this.tableEntityMap = new HashMap<String, Object>();
        HashMap entityClassMap = new HashMap();
        this.sql.append("UPDATE ");
        this.sql.append(this.getTableName(this.update.getEntityClass(), this.update, this.update));
        if (this.update instanceof EntityUpdate) {
            this.joins = ((EntityUpdate)this.update).getJoinAll();
            String tableAs = ((EntityUpdate)this.update).getTableAs();
            if (tableAs != null) {
                this.sql.append(" ").append(tableAs);
            }
            entityClassMap.put(tableAs, this.update.getEntityClass());
            this.tableEntityMap.put(tableAs, ((EntityUpdate)this.update).getEntity());
            if (this.joins != null) {
                for (JoinUpdateParam join : this.joins) {
                    EntityUpdate joinUpdate = join.getJoinUpdate();
                    entityClassMap.put(joinUpdate.getTableAs(), joinUpdate.getEntityClass());
                    this.tableEntityMap.put(joinUpdate.getTableAs(), joinUpdate.getEntity());
                }
            }
        } else {
            entityClassMap.put(null, this.update.getEntityClass());
        }
        this.appendJoinOn();
        this.sql.append(" SET");
        this.appendUpdateAll(entityClassMap);
        this.sql.append(" WHERE");
        this.appendFilters(entityClassMap);
        this.trimEndSql("WHERE");
    }

    private void appendJoinOn() {
        if (this.joins == null || this.joins.isEmpty()) {
            return;
        }
        for (JoinUpdateParam join : this.joins) {
            List<Filter> onFilters;
            final EntityUpdate mainUpdate = join.getMainUpdate();
            final EntityUpdate joinUpdate = join.getJoinUpdate();
            this.sql.append(" ").append(join.getJoinType().getJoin());
            this.sql.append(" ").append(this.getTableName(joinUpdate.getEntityClass(), joinUpdate, join));
            if (joinUpdate.getTableAs() != null) {
                this.sql.append(" ").append(joinUpdate.getTableAs());
            }
            if ((onFilters = join.getOnFilters()) == null || onFilters.size() <= 0) continue;
            this.sql.append(" ON");
            this.appendFilter(new HashMap<String, Class<?>>(){
                {
                    this.put(mainUpdate.getTableAs(), mainUpdate.getEntityClass());
                    this.put(joinUpdate.getTableAs(), joinUpdate.getEntityClass());
                }
            }, onFilters);
        }
    }

    private void appendUpdateAll(Map<String, Class<?>> entityClassMap) {
        this.appendUpdates(entityClassMap, this.update.getUpdates());
        if (this.joins == null || this.joins.isEmpty()) {
            return;
        }
        for (JoinUpdateParam join : this.joins) {
            final EntityUpdate mainUpdate = join.getMainUpdate();
            final EntityUpdate joinUpdate = join.getJoinUpdate();
            if (joinUpdate.getUpdates() == null) continue;
            this.sql.append(",");
            this.appendUpdates(new HashMap<String, Class<?>>(){
                {
                    this.put(mainUpdate.getTableAs(), mainUpdate.getEntityClass());
                    this.put(joinUpdate.getTableAs(), joinUpdate.getEntityClass());
                }
            }, joinUpdate.getUpdates());
        }
    }

    private void appendUpdates(Map<String, Class<?>> entityClassMap, Map<String, Object> updates) {
        if (updates == null || updates.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : updates.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.sql.append(" ").append(this.handleFieldToColumn(key, entityClassMap)).append(" = ");
            if (value instanceof Expression) {
                Expression expression = (Expression)value;
                this.appendExpressionValue(entityClassMap, expression);
            } else {
                this.sql.append("?");
                this.values.add(value);
            }
            this.sql.append(",");
        }
        this.trimEndSql(",");
    }

    private void appendFilters(Map<String, Class<?>> entityClassMap) {
        this.appendFilter(entityClassMap, this.update.getFilters());
        if (this.joins == null || this.joins.isEmpty()) {
            return;
        }
        for (JoinUpdateParam join : this.joins) {
            final EntityUpdate mainUpdate = join.getMainUpdate();
            final EntityUpdate joinUpdate = join.getJoinUpdate();
            if (!joinUpdate.hasFilters()) continue;
            if (!this.endsWith(" WHERE")) {
                this.sql.append(" AND");
            }
            this.appendFilter(new HashMap<String, Class<?>>(){
                {
                    this.put(mainUpdate.getTableAs(), mainUpdate.getEntityClass());
                    this.put(joinUpdate.getTableAs(), joinUpdate.getEntityClass());
                }
            }, joinUpdate.getFilters());
        }
    }

    @Override
    protected LeftRight<Boolean, Object> expressionValue(String tableAs, String field) {
        if (this.tableEntityMap == null) {
            return null;
        }
        Object entity = this.tableEntityMap.get(tableAs);
        if (entity == null && this.tableEntityMap.size() == 1) {
            entity = this.tableEntityMap.values().iterator().next();
        }
        if (entity == null) {
            if (field.startsWith("value")) {
                return LeftRight.build(Boolean.FALSE, null);
            }
            throw new DbException("\u83b7\u53d6\u5b57\u6bb5\u5931\u8d25: " + field + "\uff0c\u5bf9\u8c61\u4e3a\u7a7a");
        }
        Object value = FieldUtils.getValue(entity, field, false);
        if (value != null) {
            return LeftRight.build(Boolean.TRUE, value);
        }
        if (field.startsWith("value")) {
            return LeftRight.build(Boolean.FALSE, null);
        }
        throw new DbException("\u5b57\u6bb5\u4e0d\u5b58\u5728: " + field + " => " + entity.getClass().getName());
    }
}

