/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.jdbc;

import cn.veasion.db.base.Expression;
import cn.veasion.db.base.Filter;
import cn.veasion.db.jdbc.AbstractSQL;
import cn.veasion.db.query.AbstractJoinQuery;
import cn.veasion.db.query.AbstractQuery;
import cn.veasion.db.query.JoinQueryParam;
import cn.veasion.db.query.OrderParam;
import cn.veasion.db.query.SubQuery;
import cn.veasion.db.query.SubQueryParam;
import cn.veasion.db.query.UnionQueryParam;
import cn.veasion.db.utils.FilterUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QuerySQL
extends AbstractSQL<QuerySQL> {
    private AbstractQuery<?> query;
    private String tableAs;
    private List<JoinQueryParam> joins;
    private Map<String, String> selectFieldColumnMap;
    private SubQuery subQuery;
    private QuerySQL subQuerySQL;
    private Map<String, QuerySQL> joinSubQuerySQLMap;

    public QuerySQL(AbstractQuery<?> query) {
        this.query = query;
    }

    public static QuerySQL build(AbstractQuery<?> query) {
        return new QuerySQL(query).build();
    }

    public static QuerySQL build(AbstractQuery<?> query, Map<String, String> selectFieldColumnMap) {
        QuerySQL querySQL = new QuerySQL(query);
        querySQL.selectFieldColumnMap = selectFieldColumnMap;
        return querySQL.build();
    }

    @Override
    public QuerySQL build() {
        this.reset();
        this.buildQuery();
        return this;
    }

    private void buildQuery() {
        List<UnionQueryParam> unions;
        if (this.query instanceof SubQuery) {
            this.subQuery = (SubQuery)this.query;
            this.subQuerySQL = QuerySQL.build(this.subQuery.getSubQuery(), new HashMap<String, String>());
        }
        Map<String, Class<?>> entityClassMap = this.entityClassMap();
        this.sql.append("SELECT");
        if (this.query.isDistinct()) {
            this.sql.append(" DISTINCT");
        }
        this.appendSelects(entityClassMap, false);
        this.appendSelects(entityClassMap, true);
        this.appendSelects(this.query.getSelectSubQueryList(), true);
        this.trimEndSql(",");
        this.sql.append(" FROM ");
        if (this.subQuerySQL != null) {
            this.sql.append("(").append(this.subQuerySQL.getSQL()).append(")");
            this.values.addAll(Arrays.asList(this.subQuerySQL.getValues()));
        } else {
            this.sql.append(this.getTableName(this.query.getEntityClass(), this.query, this.query));
        }
        if (this.tableAs != null) {
            this.sql.append(" ").append(this.tableAs);
        }
        this.appendJoins();
        this.sql.append(" WHERE");
        this.appendFilters(entityClassMap);
        this.trimEndSql("WHERE");
        this.appendGroups(entityClassMap);
        if (this.query.getHaving() != null) {
            this.sql.append(" HAVING");
            this.appendFilter(entityClassMap, this.query.getHaving());
            this.trimEndSql("HAVING");
        }
        if ((unions = this.query.getUnions()) != null) {
            for (UnionQueryParam union : unions) {
                QuerySQL querySQL = QuerySQL.build(union.getUnion());
                this.sql.append(union.isUnionAll() ? " UNION ALL " : " UNION ").append(querySQL.getSQL()).append(" ");
                this.values.addAll(Arrays.asList(querySQL.getValues()));
            }
        }
        this.appendOrders(entityClassMap);
        if (this.query.getPageParam() != null) {
            this.query.getPageParam().handleSqlValue(this.sql, this.values);
        }
    }

    private Map<String, Class<?>> entityClassMap() {
        HashMap entityClassMap = new HashMap();
        if (this.query instanceof AbstractJoinQuery) {
            this.joins = ((AbstractJoinQuery)this.query).getJoinAll();
            this.tableAs = ((AbstractJoinQuery)this.query).getTableAs();
            if (this.joins != null) {
                for (JoinQueryParam join : this.joins) {
                    AbstractJoinQuery<?> joinQuery = join.getJoinQuery();
                    String tableAs = joinQuery.getTableAs();
                    if (joinQuery instanceof SubQuery) {
                        QuerySQL joinSubQuerySQL = QuerySQL.build(((SubQuery)joinQuery).getSubQuery(), new HashMap<String, String>());
                        if (this.joinSubQuerySQLMap == null) {
                            this.joinSubQuerySQLMap = new HashMap<String, QuerySQL>();
                        }
                        this.joinSubQuerySQLMap.put(tableAs, joinSubQuerySQL);
                    }
                    entityClassMap.put(tableAs, joinQuery.getEntityClass());
                }
            }
        }
        entityClassMap.put(this.tableAs, this.query.getEntityClass());
        return entityClassMap;
    }

    private void appendSelects(Map<String, Class<?>> entityClassMap, boolean isExpression) {
        if (isExpression) {
            this.appendSelects(entityClassMap, this.query.getSelectExpression());
            if (this.joins == null || this.joins.isEmpty()) {
                return;
            }
            for (JoinQueryParam join : this.joins) {
                final AbstractJoinQuery<?> mainQuery = join.getMainQuery();
                final AbstractJoinQuery<?> joinQuery = join.getJoinQuery();
                if (joinQuery.getSelectExpression() == null) continue;
                this.appendSelects(new HashMap<String, Class<?>>(){
                    {
                        this.put(mainQuery.getTableAs(), mainQuery.getEntityClass());
                        this.put(joinQuery.getTableAs(), joinQuery.getEntityClass());
                    }
                }, joinQuery.getSelectExpression());
            }
        } else {
            this.appendSelects(entityClassMap, this.query.getSelects(), this.query.getAliasMap());
            if (this.joins == null || this.joins.isEmpty()) {
                return;
            }
            for (JoinQueryParam join : this.joins) {
                final AbstractJoinQuery<?> mainQuery = join.getMainQuery();
                final AbstractJoinQuery<?> joinQuery = join.getJoinQuery();
                if (joinQuery.getSelects().isEmpty()) continue;
                this.appendSelects(new HashMap<String, Class<?>>(){
                    {
                        this.put(mainQuery.getTableAs(), mainQuery.getEntityClass());
                        this.put(joinQuery.getTableAs(), joinQuery.getEntityClass());
                    }
                }, joinQuery.getSelects(), joinQuery.getAliasMap());
            }
        }
    }

    private void appendSelects(List<SubQueryParam> list, boolean main) {
        if (list != null && !list.isEmpty()) {
            for (SubQueryParam sub : list) {
                QuerySQL querySQL = QuerySQL.build(sub.getQuery(), new LinkedHashMap<String, String>());
                this.sql.append(" (").append(querySQL.getSQL()).append(")");
                if (!querySQL.selectFieldColumnMap.isEmpty()) {
                    this.sql.append(" AS ").append(querySQL.selectFieldColumnMap.keySet().iterator().next());
                }
                this.sql.append(",");
                this.values.addAll(querySQL.values);
            }
        }
        if (main && this.joins != null && !this.joins.isEmpty()) {
            for (JoinQueryParam join : this.joins) {
                List<SubQueryParam> selectSubQueryList = join.getJoinQuery().getSelectSubQueryList();
                if (selectSubQueryList == null) continue;
                this.appendSelects(selectSubQueryList, false);
            }
        }
    }

    private void appendSelects(Map<String, Class<?>> entityClassMap, List<Expression> selectExpression) {
        if (selectExpression == null || selectExpression.isEmpty()) {
            return;
        }
        for (Expression expression : selectExpression) {
            String alias = expression.getAlias();
            if (this.selectFieldColumnMap != null && alias != null) {
                this.selectFieldColumnMap.put(alias, alias);
            }
            this.sql.append(" ");
            this.appendExpressionValue(entityClassMap, expression);
            if (alias != null) {
                this.sql.append(" AS ").append(alias);
            }
            this.sql.append(",");
        }
    }

    private void appendSelects(Map<String, Class<?>> entityClassMap, List<String> selects, Map<String, String> aliasMap) {
        if (selects == null || selects.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String select : selects) {
            String alias = aliasMap.get(select);
            String column = this.handleFieldToColumn(select, entityClassMap);
            if (this.selectFieldColumnMap != null && alias != null) {
                this.selectFieldColumnMap.put(alias, alias);
            } else if (this.selectFieldColumnMap != null) {
                this.selectFieldColumnMap.put(FilterUtils.tableAsField("-", select), FilterUtils.tableAsField("-", column));
            }
            sb.append(" ").append(column);
            if (alias != null) {
                sb.append(" AS ").append(alias);
            }
            sb.append(",");
        }
        this.sql.append(this.securityCheck(sb.toString()));
    }

    private void appendJoins() {
        if (this.joins == null || this.joins.isEmpty()) {
            return;
        }
        for (JoinQueryParam join : this.joins) {
            List<Filter> filters;
            final AbstractJoinQuery<?> mainQuery = join.getMainQuery();
            final AbstractJoinQuery<?> joinQuery = join.getJoinQuery();
            this.sql.append(" ").append(join.getJoinType().getJoin());
            if (joinQuery instanceof SubQuery) {
                QuerySQL joinSubQuerySQL = this.joinSubQuerySQLMap.get(joinQuery.getTableAs());
                this.sql.append(" (").append(joinSubQuerySQL.getSQL()).append(")");
                this.values.addAll(Arrays.asList(joinSubQuerySQL.getValues()));
            } else {
                this.sql.append(" ").append(this.getTableName(joinQuery.getEntityClass(), joinQuery, join));
            }
            if (joinQuery.getTableAs() != null) {
                this.sql.append(" ").append(joinQuery.getTableAs());
            }
            if ((filters = join.getOnFilters()) == null || filters.size() <= 0) continue;
            this.sql.append(" ON");
            this.appendFilter(new HashMap<String, Class<?>>(){
                {
                    this.put(mainQuery.getTableAs(), mainQuery.getEntityClass());
                    this.put(joinQuery.getTableAs(), joinQuery.getEntityClass());
                }
            }, filters);
        }
    }

    private void appendFilters(Map<String, Class<?>> entityClassMap) {
        this.appendFilter(entityClassMap, this.query.getFilters());
        if (this.joins == null || this.joins.isEmpty()) {
            return;
        }
        for (JoinQueryParam join : this.joins) {
            final AbstractJoinQuery<?> mainQuery = join.getMainQuery();
            final AbstractJoinQuery<?> joinQuery = join.getJoinQuery();
            if (!joinQuery.hasFilters()) continue;
            if (!this.endsWith(" WHERE")) {
                this.sql.append(" AND");
            }
            this.appendFilter(new HashMap<String, Class<?>>(){
                {
                    this.put(mainQuery.getTableAs(), mainQuery.getEntityClass());
                    this.put(joinQuery.getTableAs(), joinQuery.getEntityClass());
                }
            }, joinQuery.getFilters());
        }
    }

    private void appendGroups(Map<String, Class<?>> entityClassMap) {
        List<String> groupBys = this.query.getGroupBys();
        if (groupBys == null || groupBys.isEmpty()) {
            return;
        }
        this.sql.append(" GROUP BY");
        for (String field : groupBys) {
            this.sql.append(" ").append(this.handleFieldToColumn(field, entityClassMap)).append(",");
        }
        this.trimEndSql(",");
    }

    private void appendOrders(Map<String, Class<?>> entityClassMap) {
        List<OrderParam> orders = this.query.getOrders();
        if (orders == null || orders.isEmpty()) {
            return;
        }
        this.sql.append(" ORDER BY");
        for (OrderParam order : orders) {
            this.sql.append(" ").append(this.handleFieldToColumn(order.getField(), entityClassMap));
            if (order.isDesc()) {
                this.sql.append(" DESC");
            }
            this.sql.append(",");
        }
        this.trimEndSql(",");
    }

    @Override
    protected String toColumn(String tableAs, String field) {
        String column;
        QuerySQL joinSubQuerySQL;
        if (this.subQuery != null && this.subQuerySQL != null) {
            String column2 = this.subQuerySQL.selectFieldColumnMap.get(field);
            if (column2 != null) {
                return column2;
            }
        } else if (this.joinSubQuerySQLMap != null && tableAs != null && (joinSubQuerySQL = this.joinSubQuerySQLMap.get(tableAs)) != null && (column = joinSubQuerySQL.selectFieldColumnMap.get(field)) != null) {
            return column;
        }
        return super.toColumn(tableAs, field);
    }
}

