/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.jdbc;

import cn.veasion.db.DbException;
import cn.veasion.db.base.Expression;
import cn.veasion.db.base.IBaseId;
import cn.veasion.db.base.JdbcTypeEnum;
import cn.veasion.db.base.Page;
import cn.veasion.db.interceptor.EntityDaoInvocation;
import cn.veasion.db.interceptor.InterceptorUtils;
import cn.veasion.db.jdbc.AbstractSQL;
import cn.veasion.db.jdbc.DataSourceProvider;
import cn.veasion.db.jdbc.DeleteSQL;
import cn.veasion.db.jdbc.EntityDao;
import cn.veasion.db.jdbc.InsertSQL;
import cn.veasion.db.jdbc.JdbcDao;
import cn.veasion.db.jdbc.QuerySQL;
import cn.veasion.db.jdbc.UpdateSQL;
import cn.veasion.db.query.AbstractQuery;
import cn.veasion.db.query.PageParam;
import cn.veasion.db.query.SubQuery;
import cn.veasion.db.update.AbstractUpdate;
import cn.veasion.db.update.BatchEntityInsert;
import cn.veasion.db.update.Delete;
import cn.veasion.db.update.EntityInsert;
import cn.veasion.db.utils.FieldUtils;
import cn.veasion.db.utils.ServiceLoaderUtils;
import cn.veasion.db.utils.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcEntityDao<T, ID>
implements EntityDao<T, ID> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<T> entityClass;
    protected DataSourceProvider dataSourceProvider = ServiceLoaderUtils.dataSourceProvider();

    @Override
    public ID add(EntityInsert entityInsert) {
        entityInsert.check(this.getEntityClass());
        Object entity = entityInsert.getEntity();
        Field idField = FieldUtils.getIdField(entity.getClass());
        return (ID)InterceptorUtils.intercept(new EntityDaoInvocation<Object>(this, "add", new Object[]{entityInsert}, () -> {
            InsertSQL insertSQL = entityInsert.sqlValue();
            return this.executeJdbc(JdbcTypeEnum.INSERT, connection -> {
                Object[] objects = JdbcDao.executeInsert(connection, insertSQL.getSQL(), insertSQL.getValues());
                if (objects.length > 0) {
                    Object id = TypeUtils.convert(objects[0], idField.getType());
                    if (entity instanceof IBaseId) {
                        ((IBaseId)entity).setId(id);
                    }
                    return id;
                }
                return entity instanceof IBaseId ? ((IBaseId)entity).getId() : null;
            });
        }));
    }

    @Override
    public ID[] batchAdd(BatchEntityInsert batchEntityInsert) {
        batchEntityInsert.check(this.getEntityClass());
        AbstractQuery<T> insertSelectQuery = batchEntityInsert.getInsertSelectQuery();
        if (insertSelectQuery != null) {
            insertSelectQuery.check(this.getEntityClass());
        }
        return InterceptorUtils.intercept(new EntityDaoInvocation<Object[]>(this, "batchAdd", new Object[]{batchEntityInsert}, () -> {
            InsertSQL insertSQL = batchEntityInsert.sqlValue();
            Field idField = FieldUtils.getIdField(this.getEntityClass());
            List<?> entityList = batchEntityInsert.getEntityList();
            return this.executeJdbc(JdbcTypeEnum.INSERT, connection -> {
                Object[] objects = JdbcDao.executeInsert(connection, insertSQL.getSQL(), insertSQL.getValues());
                if (idField == null) {
                    return null;
                }
                Object[] ids = (Object[])Array.newInstance(idField.getType(), objects.length > 0 ? objects.length : entityList.size());
                if (objects.length > 0) {
                    for (int i = 0; i < objects.length; ++i) {
                        Object id = TypeUtils.convert(objects[i], idField.getType());
                        Array.set(ids, i, id);
                        if (entityList == null || !(entityList.get(i) instanceof IBaseId)) continue;
                        ((IBaseId)entityList.get(i)).setId(id);
                    }
                } else {
                    for (int i = 0; i < entityList.size(); ++i) {
                        if (!(entityList.get(i) instanceof IBaseId)) continue;
                        Array.set(ids, i, ((IBaseId)entityList.get(i)).getId());
                    }
                }
                return ids;
            });
        }));
    }

    @Override
    public <E> E queryForType(AbstractQuery<?> query, Class<E> clazz) {
        query.check(this.getEntityClass());
        return (E)InterceptorUtils.intercept(new EntityDaoInvocation<Object>(this, "queryForType", new Object[]{query, clazz}, () -> {
            QuerySQL querySQL = query.sqlValue();
            return this.executeJdbc(JdbcTypeEnum.SELECT, connection -> JdbcDao.queryForType(connection, clazz, querySQL.getSQL(), querySQL.getValues()));
        }));
    }

    @Override
    public Map<String, Object> queryForMap(AbstractQuery<?> query, boolean mapUnderscoreToCamelCase) {
        query.check(this.getEntityClass());
        return InterceptorUtils.intercept(new EntityDaoInvocation<Map>(this, "queryForMap", new Object[]{query, mapUnderscoreToCamelCase}, () -> {
            QuerySQL querySQL = query.sqlValue();
            return this.executeJdbc(JdbcTypeEnum.SELECT, connection -> JdbcDao.queryForMap(connection, mapUnderscoreToCamelCase, querySQL.getSQL(), querySQL.getValues()));
        }));
    }

    @Override
    public List<Map<String, Object>> listForMap(AbstractQuery<?> query, boolean mapUnderscoreToCamelCase) {
        query.check(this.getEntityClass());
        return InterceptorUtils.intercept(new EntityDaoInvocation<List>(this, "listForMap", new Object[]{query, mapUnderscoreToCamelCase}, () -> {
            QuerySQL querySQL = query.sqlValue();
            return this.executeJdbc(JdbcTypeEnum.SELECT, connection -> JdbcDao.listForMap(connection, mapUnderscoreToCamelCase, querySQL.getSQL(), querySQL.getValues()));
        }));
    }

    @Override
    public <E> List<E> queryList(AbstractQuery<?> query, Class<E> clazz) {
        query.check(this.getEntityClass());
        return InterceptorUtils.intercept(new EntityDaoInvocation<List>(this, "queryList", new Object[]{query, clazz}, () -> {
            QuerySQL querySQL = query.sqlValue();
            return this.executeJdbc(JdbcTypeEnum.SELECT, connection -> JdbcDao.listForType(connection, clazz, querySQL.getSQL(), querySQL.getValues()));
        }));
    }

    @Override
    public <E> Page<E> queryPage(AbstractQuery<?> query, Class<E> clazz) {
        if (query.getPageParam() == null) {
            throw new DbException("\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SubQuery countQuery = (SubQuery)new SubQuery(query, "t").selectExpression(Expression.select("count(1)", null, new Object[0]));
        countQuery.check(this.getEntityClass());
        return InterceptorUtils.intercept(new EntityDaoInvocation<Page>(this, "queryPage", new Object[]{query, clazz}, () -> {
            PageParam pageParam = query.getPageParam();
            try {
                query.page(null);
                QuerySQL countQuerySQL = countQuery.sqlValue();
                Page page = this.executeJdbc(JdbcTypeEnum.SELECT, connection -> {
                    Object value = JdbcDao.queryOnly(connection, countQuerySQL.getSQL(), countQuerySQL.getValues());
                    Integer count = TypeUtils.convert(value, Integer.class);
                    query.page(pageParam);
                    if (count > 0) {
                        QuerySQL listQuerySQL = query.sqlValue();
                        List list = JdbcDao.listForType(connection, clazz, listQuerySQL.getSQL(), listQuerySQL.getValues());
                        return new Page(count, list);
                    }
                    return new Page(count, new ArrayList());
                });
                return page;
            }
            finally {
                query.page(pageParam);
            }
        }));
    }

    @Override
    public int update(AbstractUpdate<?> update) {
        update.check(this.getEntityClass());
        return InterceptorUtils.intercept(new EntityDaoInvocation<Integer>(this, "update", new Object[]{update}, () -> {
            UpdateSQL updateSQL = update.sqlValue();
            return this.executeJdbc(JdbcTypeEnum.UPDATE, connection -> JdbcDao.executeUpdate(connection, updateSQL.getSQL(), updateSQL.getValues()));
        }));
    }

    @Override
    public int delete(Delete delete) {
        delete.check(this.getEntityClass());
        return InterceptorUtils.intercept(new EntityDaoInvocation<Integer>(this, "delete", new Object[]{delete}, () -> {
            AbstractSQL abstractSQL;
            JdbcTypeEnum jdbcTypeEnum;
            AbstractUpdate<T> convertUpdate = delete.getConvertUpdate();
            if (convertUpdate != null) {
                if (!convertUpdate.hasFilters()) {
                    delete.getFilters().forEach(convertUpdate::addFilter);
                }
                if (convertUpdate.getEntityClass() == null) {
                    convertUpdate.setEntityClass(this.getEntityClass());
                }
                jdbcTypeEnum = JdbcTypeEnum.UPDATE;
                abstractSQL = convertUpdate.sqlValue();
            } else {
                jdbcTypeEnum = JdbcTypeEnum.DELETE;
                abstractSQL = DeleteSQL.build(delete);
            }
            return this.executeJdbc(jdbcTypeEnum, connection -> JdbcDao.executeUpdate(connection, abstractSQL.getSQL(), abstractSQL.getValues()));
        }));
    }

    @Override
    public Class<T> getEntityClass() {
        ParameterizedType parameterizedType;
        Type rawType;
        if (this.entityClass != null) {
            return this.entityClass;
        }
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)genericSuperclass).getRawType()) instanceof Class && JdbcEntityDao.class.isAssignableFrom((Class)rawType)) {
            this.entityClass = (Class)parameterizedType.getActualTypeArguments()[0];
            return this.entityClass;
        }
        throw new RuntimeException("\u83b7\u53d6\u5b9e\u4f53\u7c7b\u578b\u5931\u8d25\uff0c\u8bf7\u91cd\u5199 getEntityClass() \u65b9\u6cd5");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R executeJdbc(JdbcTypeEnum jdbcTypeEnum, Function<Connection, R> function) {
        Connection connection;
        if (this.dataSourceProvider == null) {
            this.logger.info("\u8bf7\u901a\u8fc7SPI\u5b9e\u73b0cn.veasion.db.jdbc.DataSourceProvider\u63a5\u53e3");
            throw new DbException("\u672a\u83b7\u53d6\u5230 dataSourceProvider");
        }
        DataSource dataSource = this.dataSourceProvider.getDataSource(this, jdbcTypeEnum);
        try {
            connection = this.dataSourceProvider.getConnection(dataSource);
        }
        catch (SQLException e) {
            throw new DbException("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25", e);
        }
        try {
            R r = function.apply(connection);
            return r;
        }
        finally {
            this.dataSourceProvider.releaseConnection(dataSource, connection);
        }
    }
}

