/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.jdbc;

import cn.veasion.db.DbException;
import cn.veasion.db.utils.FieldUtils;
import cn.veasion.db.utils.TypeUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcDao.class);

    public static int executeUpdate(Connection connection, String sql, Object ... params) {
        int count;
        PreparedStatement ps = null;
        try {
            ps = JdbcDao.prepareStatement(connection, sql, params);
            count = ps.executeUpdate();
            LOGGER.info("<==    Updates: {}", (Object)count);
        }
        catch (SQLException e) {
            throw new DbException("\u66f4\u65b0\u5f02\u5e38", e);
        }
        finally {
            JdbcDao.closeAll(ps, null);
        }
        return count;
    }

    public static Object[] executeInsert(Connection connection, String sql, Object ... params) {
        PreparedStatement ps = null;
        ResultSet result = null;
        ArrayList<Object> keys = new ArrayList<Object>();
        try {
            ps = JdbcDao.prepareStatement(connection, 1, sql, params);
            int count = ps.executeUpdate();
            if (count > 0) {
                result = ps.getGeneratedKeys();
                while (result != null && result.next()) {
                    keys.add(result.getObject(1));
                }
            }
            LOGGER.info("<==    Updates: {}", (Object)count);
        }
        catch (SQLException e) {
            try {
                throw new DbException("\u65b0\u589e\u5f02\u5e38", e);
            }
            catch (Throwable throwable) {
                JdbcDao.closeAll(ps, result);
                throw throwable;
            }
        }
        JdbcDao.closeAll(ps, result);
        return keys.toArray();
    }

    public static List<Map<String, Object>> listForMap(Connection connection, String sql, Object ... params) {
        return JdbcDao.listForMap(connection, true, sql, params);
    }

    public static List<Map<String, Object>> listForMap(Connection connection, boolean mapUnderscoreToCamelCase, String sql, Object ... params) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            ps = JdbcDao.prepareStatement(connection, sql, params);
            rs = ps.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                ResultSetMetaData data = rs.getMetaData();
                int count = data.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    String columnName = data.getColumnLabel(i);
                    if (mapUnderscoreToCamelCase) {
                        columnName = FieldUtils.lineToHump(columnName);
                    }
                    map.put(columnName, rs.getObject(i));
                }
                list.add(map);
            }
            LOGGER.info("<==      Total: {}", (Object)list.size());
        }
        catch (SQLException e) {
            try {
                throw new DbException("\u67e5\u8be2\u5f02\u5e38", e);
            }
            catch (Throwable throwable) {
                JdbcDao.closeAll(ps, rs);
                throw throwable;
            }
        }
        JdbcDao.closeAll(ps, rs);
        return list;
    }

    public static Map<String, Object> queryForMap(Connection connection, String sql, Object ... params) {
        return JdbcDao.queryForMap(connection, true, sql, params);
    }

    public static Map<String, Object> queryForMap(Connection connection, boolean mapUnderscoreToCamelCase, String sql, Object ... params) {
        List<Map<String, Object>> list = JdbcDao.listForMap(connection, mapUnderscoreToCamelCase, sql, params);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new DbException("\u67e5\u8be2\u6709\u591a\u4e2a\u7ed3\u679c\uff1a" + sql);
        }
        return list.get(0);
    }

    public static <T> T queryForType(Connection connection, Class<T> clazz, String sql, Object ... params) {
        List<T> list = JdbcDao.listForType(connection, clazz, sql, params);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new DbException("\u67e5\u8be2\u6709\u591a\u4e2a\u7ed3\u679c(" + list.size() + ")\uff1a" + sql);
        }
        return list.get(0);
    }

    public static <T> List<T> listForType(Connection connection, Class<T> clazz, String sql, Object ... params) {
        return JdbcDao.listForType(connection, clazz, null, sql, params);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> List<T> listForType(Connection connection, Class<T> clazz, FieldAssignmentHandler handler, String sql, Object ... params) {
        ResultSet rs = null;
        PreparedStatement ps = null;
        ArrayList<T> list = new ArrayList<T>();
        Map<String, String> fieldColumnMap = FieldUtils.fieldColumns(clazz);
        Map<String, String> columnFieldMap = fieldColumnMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1));
        try {
            ps = JdbcDao.prepareStatement(connection, sql, params);
            rs = ps.executeQuery();
            while (rs.next()) {
                Object object;
                ResultSetMetaData data = rs.getMetaData();
                int count = data.getColumnCount();
                if (count == 1 && ((object = rs.getObject(1)) != null && clazz.isAssignableFrom(object.getClass()) || TypeUtils.isSimpleClass(clazz))) {
                    list.add(TypeUtils.convert(object, clazz));
                    continue;
                }
                T obj = TypeUtils.newInstance(clazz);
                for (int i = 1; i <= count; ++i) {
                    String columnName = data.getColumnLabel(i);
                    String fieldName = null;
                    if (fieldColumnMap.containsKey(columnName)) {
                        fieldName = columnName;
                    } else if (columnFieldMap.containsKey(columnName)) {
                        fieldName = columnFieldMap.get(columnName);
                    }
                    if (fieldName == null) continue;
                    if (handler != null) {
                        handler.handle(obj, fieldName, rs.getObject(i));
                        continue;
                    }
                    FieldUtils.setValue(obj, fieldName, rs.getObject(i), true);
                }
                list.add(obj);
            }
            LOGGER.info("<==      Total: {}", (Object)list.size());
        }
        catch (SQLException e) {
            try {
                throw new DbException("\u67e5\u8be2\u5f02\u5e38", e);
                catch (RuntimeException e2) {
                    LOGGER.error("\u67e5\u8be2\u5904\u7406\u6570\u636e\u5f02\u5e38", (Throwable)e2);
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                JdbcDao.closeAll(ps, rs);
                throw throwable;
            }
        }
        JdbcDao.closeAll(ps, rs);
        return list;
    }

    public static Object queryOnly(Connection connection, String sql, Object ... params) {
        Object value = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = JdbcDao.prepareStatement(connection, sql, params);
            rs = ps.executeQuery();
            if (rs.next()) {
                value = rs.getObject(1);
            }
            int total = 1;
            while (rs.next()) {
                ++total;
            }
            LOGGER.info("<==      Total: {}", (Object)total);
        }
        catch (SQLException e) {
            try {
                throw new DbException("\u67e5\u8be2\u5f02\u5e38", e);
            }
            catch (Throwable throwable) {
                JdbcDao.closeAll(ps, rs);
                throw throwable;
            }
        }
        JdbcDao.closeAll(ps, rs);
        return value;
    }

    private static PreparedStatement prepareStatement(Connection connection, String sql, Object ... params) throws SQLException {
        return JdbcDao.prepareStatement(connection, 2, sql, params);
    }

    private static PreparedStatement prepareStatement(Connection connection, int autoGeneratedKeys, String sql, Object ... params) throws SQLException {
        PreparedStatement ps = connection.prepareStatement(sql, autoGeneratedKeys);
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("==>  Preparing: {}", (Object)sql);
            LOGGER.info("==> Parameters: {}", (Object)JdbcDao.paramToString(params));
        }
        return ps;
    }

    private static String paramToString(Object[] params) {
        if (params == null || params.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object param : params) {
            sb.append(param);
            if (param != null) {
                sb.append("(").append(param.getClass().getSimpleName()).append(")");
            }
            sb.append(", ");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    private static void closeAll(Statement ps, ResultSet rs) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @FunctionalInterface
    public static interface FieldAssignmentHandler {
        public void handle(Object var1, String var2, Object var3);
    }
}

