/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.jdbc;

import cn.veasion.db.DbException;
import cn.veasion.db.jdbc.AbstractSQL;
import cn.veasion.db.jdbc.QuerySQL;
import cn.veasion.db.query.AbstractQuery;
import cn.veasion.db.update.BatchEntityInsert;
import cn.veasion.db.update.EntityInsert;
import cn.veasion.db.utils.FieldUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InsertSQL
extends AbstractSQL<InsertSQL> {
    private EntityInsert entityInsert;
    private BatchEntityInsert batchEntityInsert;

    public InsertSQL(EntityInsert entityInsert) {
        this.entityInsert = entityInsert;
    }

    public InsertSQL(BatchEntityInsert batchEntityInsert) {
        this.batchEntityInsert = batchEntityInsert;
    }

    public static InsertSQL build(EntityInsert entityInsert) {
        return new InsertSQL(entityInsert).build();
    }

    public static InsertSQL build(BatchEntityInsert batchEntityInsert) {
        return new InsertSQL(batchEntityInsert).build();
    }

    @Override
    public InsertSQL build() {
        this.reset();
        if (this.entityInsert != null) {
            this.insert(this.entityInsert.getEntityClass(), Collections.singletonList(this.entityInsert.getFieldValueMap()), this.entityInsert);
        } else {
            AbstractQuery<?> insertSelectQuery = this.batchEntityInsert.getInsertSelectQuery();
            if (insertSelectQuery != null) {
                this.insertSelect(this.batchEntityInsert.getEntityClass(), insertSelectQuery);
            } else {
                this.insert(this.batchEntityInsert.getEntityClass(), this.batchEntityInsert.getFieldValueMapList(), this.batchEntityInsert);
            }
        }
        return this;
    }

    private void insert(Class<?> entityClazz, List<Map<String, Object>> fieldValueMapList, Object source) {
        if (fieldValueMapList == null || fieldValueMapList.isEmpty()) {
            throw new DbException("fieldValueMapList is empty");
        }
        Map<String, String> fieldColumns = FieldUtils.entityFieldColumns(entityClazz);
        Set<String> fields = fieldValueMapList.get(0).keySet();
        this.sql.append("INSERT INTO ");
        this.sql.append(this.getTableName(entityClazz, null, source)).append(" (");
        for (String string : fields) {
            this.appendInsertColumn(fieldColumns.get(string));
        }
        this.trimEndSql(",");
        this.sql.append(") VALUES");
        for (Map map : fieldValueMapList) {
            for (String field : fields) {
                this.values.add(map.get(field));
            }
            this.sql.append(" (").append(InsertSQL.sqlPlaceholder(map.size())).append(")").append(",");
        }
        this.trimEndSql(",");
    }

    private void insertSelect(Class<?> entityClass, AbstractQuery<?> query) {
        Map<String, String> fieldColumns = FieldUtils.entityFieldColumns(entityClass);
        LinkedHashMap<String, String> selectFieldColumnMap = new LinkedHashMap<String, String>();
        QuerySQL querySQL = QuerySQL.build(query, selectFieldColumnMap);
        this.sql.append("INSERT INTO ");
        this.sql.append(this.getTableName(entityClass, query, this.batchEntityInsert)).append(" (");
        for (String field : selectFieldColumnMap.keySet()) {
            this.appendInsertColumn(fieldColumns.getOrDefault(field, selectFieldColumnMap.getOrDefault(field, field)));
        }
        this.trimEndSql(",");
        this.sql.append(") ");
        this.sql.append(querySQL.getSQL());
        this.values.addAll(Arrays.asList(querySQL.getValues()));
    }

    private void appendInsertColumn(String column) {
        if (column.startsWith("`") && column.endsWith("`")) {
            this.sql.append(column).append(",");
        } else {
            this.sql.append("`").append(column).append("`").append(",");
        }
    }
}

