/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.jdbc;

import cn.veasion.db.base.Page;
import cn.veasion.db.query.AbstractQuery;
import cn.veasion.db.query.Query;
import cn.veasion.db.update.AbstractUpdate;
import cn.veasion.db.update.BatchEntityInsert;
import cn.veasion.db.update.Delete;
import cn.veasion.db.update.EntityInsert;
import cn.veasion.db.update.EntityUpdate;
import cn.veasion.db.utils.FieldUtils;
import java.util.List;
import java.util.Map;

public interface EntityDao<T, ID> {
    default public ID add(T entity) {
        return this.add(new EntityInsert(entity));
    }

    public ID add(EntityInsert var1);

    default public ID[] batchAdd(List<T> entityList) {
        return this.batchAdd(new BatchEntityInsert(entityList));
    }

    public ID[] batchAdd(BatchEntityInsert var1);

    default public T getById(ID id) {
        return this.query((AbstractQuery)new Query().eq(this.getIdField(), id));
    }

    default public T query(AbstractQuery<?> query) {
        return this.queryForType(query, this.getEntityClass());
    }

    public <E> E queryForType(AbstractQuery<?> var1, Class<E> var2);

    default public Map<String, Object> queryForMap(AbstractQuery<?> query) {
        return this.queryForMap(query, true);
    }

    public Map<String, Object> queryForMap(AbstractQuery<?> var1, boolean var2);

    default public List<Map<String, Object>> listForMap(AbstractQuery<?> query) {
        return this.listForMap(query, true);
    }

    public List<Map<String, Object>> listForMap(AbstractQuery<?> var1, boolean var2);

    default public List<T> queryList(AbstractQuery<?> query) {
        return this.queryList(query, this.getEntityClass());
    }

    public <E> List<E> queryList(AbstractQuery<?> var1, Class<E> var2);

    default public Page<T> queryPage(AbstractQuery<?> query) {
        return this.queryPage(query, this.getEntityClass());
    }

    public <E> Page<E> queryPage(AbstractQuery<?> var1, Class<E> var2);

    default public int updateById(T entity) {
        return this.update((AbstractUpdate<?>)new EntityUpdate(entity).eq(this.getIdField()).excludeUpdateFilterFields().skipNullField());
    }

    public int update(AbstractUpdate<?> var1);

    default public int deleteById(ID id) {
        return this.delete((Delete)new Delete().eq(this.getIdField(), id));
    }

    public int delete(Delete var1);

    default public String getIdField() {
        return FieldUtils.getIdField(this.getEntityClass()).getName();
    }

    public Class<T> getEntityClass();
}

