/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.jdbc;

import cn.veasion.db.AbstractFilter;
import cn.veasion.db.DbException;
import cn.veasion.db.jdbc.DynamicTableExt;
import cn.veasion.db.query.AbstractJoinQuery;
import cn.veasion.db.query.AbstractQuery;
import cn.veasion.db.query.JoinQueryParam;
import cn.veasion.db.update.AbstractUpdate;
import cn.veasion.db.update.BatchEntityInsert;
import cn.veasion.db.update.Delete;
import cn.veasion.db.update.EntityInsert;
import cn.veasion.db.update.EntityUpdate;
import cn.veasion.db.update.JoinUpdateParam;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class DefaultDynamicTableExt
implements DynamicTableExt {
    private static final ThreadLocal<DynamicTableExt> threadLocal = new ThreadLocal();
    private static final Map<Class<?>, DynamicTableExt> globalMap = new ConcurrentHashMap();

    @Override
    public String getTableName(String tableName, Class<?> entityClazz, AbstractFilter<?> filter, Object source) {
        String changeTableName;
        DynamicTableExt dynamicTableExt = threadLocal.get();
        if (dynamicTableExt != null && (changeTableName = dynamicTableExt.getTableName(tableName, entityClazz, filter, source)) != null) {
            return changeTableName;
        }
        if (globalMap.containsKey(entityClazz) && (changeTableName = globalMap.get(entityClazz).getTableName(tableName, entityClazz, filter, source)) != null) {
            return changeTableName;
        }
        return tableName;
    }

    public static <T> T withDynamicTableExt(DynamicTableExt dynamicTableExt, Supplier<T> supplier) {
        try {
            threadLocal.set(dynamicTableExt);
            T t = supplier.get();
            return t;
        }
        finally {
            threadLocal.remove();
        }
    }

    public static void addGlobalDynamicTableExt(Class<?> entityClazz, DynamicTableExt tableExt) {
        globalMap.put(entityClazz, tableExt);
    }

    public static abstract class AbstractDynamicTableExt
    implements DynamicTableExt {
        @Override
        public String getTableName(String tableName, Class<?> entityClazz, AbstractFilter<?> filter, Object source) {
            tableName = source instanceof EntityInsert ? this.handleAdd(tableName, entityClazz, (EntityInsert)source) : (source instanceof BatchEntityInsert ? (filter != null ? this.handleBatchAdd(tableName, entityClazz, (BatchEntityInsert)source, true) : this.handleBatchAdd(tableName, entityClazz, (BatchEntityInsert)source, false)) : (source instanceof JoinUpdateParam ? this.handleUpdateJoin(tableName, entityClazz, (JoinUpdateParam)source, (EntityUpdate)filter) : (source instanceof JoinQueryParam ? this.handleQueryJoin(tableName, entityClazz, (JoinQueryParam)source, (AbstractJoinQuery)filter) : (source instanceof Delete ? this.handleDelete(tableName, entityClazz, (Delete)source) : (filter instanceof AbstractQuery ? this.handleQuery(tableName, entityClazz, (AbstractQuery)filter) : (filter instanceof AbstractUpdate ? this.handleUpdate(tableName, entityClazz, (AbstractUpdate)filter) : this.handleFilter(tableName, entityClazz, filter)))))));
            return tableName;
        }

        protected abstract String handleAdd(String var1, Class<?> var2, EntityInsert var3);

        protected String handleBatchAdd(String tableName, Class<?> entityClazz, BatchEntityInsert batchEntityInsert, boolean insertSelect) {
            throw new DbException("\u6279\u91cf\u65b0\u589e\u4e0d\u652f\u6301\u52a8\u6001\u5206\u8868\uff0c\u8bf7\u901a\u8fc7\u8def\u7531\u6761\u4ef6\u62c6\u5206\u8c03\u7528 DefaultDynamicTableExt.withDynamicTableExt \u81ea\u5b9a\u4e49\u5904\u7406");
        }

        protected String handleUpdateJoin(String tableName, Class<?> entityClazz, JoinUpdateParam join, EntityUpdate joinUpdate) {
            return this.handleFilter(tableName, entityClazz, joinUpdate);
        }

        protected String handleQueryJoin(String tableName, Class<?> entityClazz, JoinQueryParam join, AbstractJoinQuery<?> joinQuery) {
            return this.handleFilter(tableName, entityClazz, joinQuery);
        }

        protected String handleDelete(String tableName, Class<?> entityClazz, Delete delete) {
            return this.handleFilter(tableName, entityClazz, delete);
        }

        protected String handleQuery(String tableName, Class<?> entityClazz, AbstractQuery<?> query) {
            return this.handleFilter(tableName, entityClazz, query);
        }

        protected String handleUpdate(String tableName, Class<?> entityClazz, AbstractUpdate<?> update) {
            return this.handleFilter(tableName, entityClazz, update);
        }

        protected abstract String handleFilter(String var1, Class<?> var2, AbstractFilter<?> var3);
    }
}

