/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.jdbc;

import cn.veasion.db.AbstractFilter;
import cn.veasion.db.DbException;
import cn.veasion.db.FilterException;
import cn.veasion.db.base.Expression;
import cn.veasion.db.base.Filter;
import cn.veasion.db.base.Operator;
import cn.veasion.db.jdbc.DynamicTableExt;
import cn.veasion.db.jdbc.QuerySQL;
import cn.veasion.db.query.SubQueryParam;
import cn.veasion.db.utils.FieldUtils;
import cn.veasion.db.utils.LeftRight;
import cn.veasion.db.utils.ServiceLoaderUtils;
import cn.veasion.db.utils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class AbstractSQL<T> {
    protected StringBuilder sql = new StringBuilder();
    protected List<Object> values = new ArrayList<Object>();
    protected DynamicTableExt dynamicTableExt = ServiceLoaderUtils.dynamicTableExt();

    public String getSQL() {
        return this.sql.toString();
    }

    public Object[] getValues() {
        return this.values.toArray();
    }

    public void reset() {
        this.sql.setLength(0);
        this.values.clear();
    }

    public abstract T build();

    protected String getTableName(Class<?> entityClazz, AbstractFilter<?> filter, Object source) {
        String tableName = TypeUtils.getTableName(entityClazz);
        if (this.dynamicTableExt != null) {
            String changeTableName = this.dynamicTableExt.getTableName(tableName, entityClazz, filter, source);
            tableName = changeTableName != null ? changeTableName : tableName;
        }
        return tableName;
    }

    protected void appendFilter(Map<String, Class<?>> entityClassMap, List<Filter> filters) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (Filter filter : filters) {
            boolean multiple;
            this.sql.append(" ");
            if (filter.isSpecial()) {
                if (filter.getValue() instanceof SubQueryParam) {
                    if (filter.getField() != null || !Operator.EXISTS.equals((Object)filter.getOperator()) && !Operator.NOT_EXISTS.equals((Object)filter.getOperator())) {
                        this.sql.append(this.handleFieldToColumn(filter.getField(), entityClassMap)).append(" ");
                    }
                    this.sql.append(filter.getOperator().getOpt()).append(" (");
                    SubQueryParam subQueryParam = (SubQueryParam)filter.getValue();
                    QuerySQL querySQL = QuerySQL.build(subQueryParam.getQuery());
                    this.sql.append((CharSequence)querySQL.sql);
                    this.values.addAll(querySQL.values);
                    this.sql.append(")");
                    continue;
                }
                if (filter.getValue() instanceof Expression) {
                    this.sql.append(this.handleFieldToColumn(filter.getField(), entityClassMap));
                    this.sql.append(" ").append(filter.getOperator().getOpt()).append(" ");
                    Expression expression = (Expression)filter.getValue();
                    this.appendExpressionValue(entityClassMap, expression);
                    continue;
                }
                throw new FilterException("\u4e0d\u652f\u6301\u8fc7\u6ee4\u5668\uff1a" + filter);
            }
            if (filter.getField() == null || !filter.getSql().contains("?")) {
                if (filter.getField() != null) {
                    this.sql.append(this.handleFieldToColumn(filter.getField(), entityClassMap)).append(" ");
                }
                this.sql.append(filter.getSql());
                continue;
            }
            this.sql.append(this.handleFieldToColumn(filter.getField(), entityClassMap));
            this.sql.append(" ");
            this.sql.append(filter.getSql());
            Object value = filter.getValue();
            boolean bl = multiple = filter.getSql().indexOf("?") != filter.getSql().lastIndexOf("?");
            if (value instanceof Collection) {
                if (multiple || ((Collection)value).size() == 1) {
                    this.values.addAll((Collection)value);
                    continue;
                }
                throw new FilterException("\u5f02\u5e38SQL\u7c7b\u578b\uff1a" + filter.getSql());
            }
            if (value instanceof Object[]) {
                if (multiple || ((Object[])value).length == 1) {
                    this.values.addAll(Arrays.asList((Object[])value));
                    continue;
                }
                throw new FilterException("\u5f02\u5e38SQL\u7c7b\u578b\uff1a" + filter.getSql());
            }
            this.values.add(value);
        }
        this.trimEndSql("AND");
    }

    protected void appendExpressionValue(Map<String, Class<?>> entityClassMap, Expression expression) {
        String eval = this.replaceSqlEval(expression.getExpression(), entityClassMap);
        if (eval.contains("#{")) {
            Object[] vs = expression.getValues();
            eval = FieldUtils.replaceSqlPlaceholder(eval, null, (tableAs, field) -> {
                LeftRight<Boolean, Object> value = this.expressionValue((String)tableAs, (String)field);
                if (value != null && Boolean.TRUE.equals(value.getLeft())) {
                    this.values.add(value.getRight());
                } else {
                    if (tableAs != null && !"".equals(tableAs) || !field.startsWith("value")) {
                        throw new DbException("\u5360\u4f4d\u7b26\u683c\u5f0f\u9519\u8bef\uff1a" + field);
                    }
                    try {
                        int index = Integer.parseInt(field.substring(5)) - 1;
                        this.values.add(vs[index]);
                    }
                    catch (Exception e) {
                        throw new DbException("\u8868\u8fbe\u5f0f\u9519\u8bef\uff1a" + expression.getExpression(), e);
                    }
                }
                return "?";
            }, "#{", "}");
        }
        this.sql.append(eval);
    }

    protected String replaceSqlEval(String eval, Map<String, Class<?>> entityClassMap) {
        if (!eval.contains("${")) {
            return eval;
        }
        return FieldUtils.replaceSqlPlaceholder(eval, null, (tableAs, field) -> {
            String toColumn = this.toColumn((String)tableAs, (String)field);
            if (toColumn != null) {
                return toColumn;
            }
            Class clazz = (Class)entityClassMap.get(tableAs);
            if (clazz == null && tableAs == null && entityClassMap.size() == 1) {
                clazz = (Class)entityClassMap.values().iterator().next();
            }
            if (clazz == null) {
                if (field.endsWith("`") && field.endsWith("`")) {
                    return field;
                }
                return FieldUtils.humpToLine(field);
            }
            return FieldUtils.entityFieldColumns(clazz).getOrDefault(field, (String)field);
        });
    }

    protected String handleFieldToColumn(String field, Map<String, Class<?>> entityClassMap) {
        Class<?> clazz;
        int idx = field.indexOf(".");
        if (idx > 0) {
            String _field;
            String tableAs = field.substring(0, idx);
            String toColumn = this.toColumn(tableAs, _field = field.substring(idx + 1).trim());
            if (toColumn != null) {
                return tableAs + "." + toColumn;
            }
            Class<?> clazz2 = entityClassMap.get(tableAs);
            if (clazz2 == null) {
                return field;
            }
            return tableAs + "." + FieldUtils.entityFieldColumns(clazz2).getOrDefault(_field, _field);
        }
        String toColumn = this.toColumn(null, field);
        if (toColumn != null) {
            return toColumn;
        }
        Class<?> clazz3 = clazz = entityClassMap.size() == 1 ? entityClassMap.values().iterator().next() : entityClassMap.get(null);
        if (clazz == null) {
            return field;
        }
        return FieldUtils.entityFieldColumns(clazz).getOrDefault(field, field);
    }

    protected LeftRight<Boolean, Object> expressionValue(String tableAs, String field) {
        return null;
    }

    protected String toColumn(String tableAs, String field) {
        return null;
    }

    public static String sqlPlaceholder(int len) {
        Object[] array = new String[len];
        Arrays.fill(array, "?");
        return String.join((CharSequence)",", (CharSequence[])array);
    }

    protected void trimEndSql(String end) {
        if (this.endsWith(end)) {
            this.sql.setLength(this.sql.length() - end.length());
        }
    }

    protected boolean endsWith(String end) {
        int len1 = end.length();
        int len2 = this.sql.length() - len1;
        for (int i = 0; i < len1; ++i) {
            if (end.charAt(i) == this.sql.charAt(len2 + i)) continue;
            return false;
        }
        return true;
    }

    protected String securityCheck(String sql) {
        return sql;
    }
}

