/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.interceptor;

import cn.veasion.db.AbstractFilter;
import cn.veasion.db.base.Expression;
import cn.veasion.db.base.Filter;
import cn.veasion.db.interceptor.AbstractInterceptor;
import cn.veasion.db.update.Delete;
import cn.veasion.db.update.Update;
import cn.veasion.db.utils.FilterUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LogicDeleteInterceptor
extends AbstractInterceptor {
    private static ThreadLocal<Boolean> skipLogicDeleteFilter = new ThreadLocal();
    private static ThreadLocal<Set<Class<?>>> skipClassLogicDeleteFilter = new ThreadLocal();
    private String logicDeleteField;
    private Object availableValue;
    private Object deletedValue;

    public LogicDeleteInterceptor(String logicDeleteField, Object availableValue, Object deletedValue) {
        super(true, true, true, true, false);
        this.logicDeleteField = Objects.requireNonNull(logicDeleteField);
        this.availableValue = Objects.requireNonNull(availableValue);
        this.deletedValue = Objects.requireNonNull(deletedValue);
    }

    public static void skip(boolean skip) {
        skipLogicDeleteFilter.set(skip);
    }

    public static void skip(Class<?> ... classes) {
        skipClassLogicDeleteFilter.set(new HashSet(Arrays.asList(classes)));
    }

    public static void clearSkip() {
        skipLogicDeleteFilter.remove();
        skipClassLogicDeleteFilter.remove();
    }

    @Override
    protected boolean skip() {
        return Boolean.TRUE.equals(skipLogicDeleteFilter.get());
    }

    @Override
    protected boolean containSkipClass(Class<?> clazz) {
        return skipClassLogicDeleteFilter.get() != null && skipClassLogicDeleteFilter.get().contains(clazz);
    }

    @Override
    protected void handleDelete(Delete delete) {
        Update convertUpdate = delete.getConvertUpdate();
        if (convertUpdate == null) {
            convertUpdate = new Update();
        }
        if (this.deletedValue instanceof Expression) {
            convertUpdate.updateExpression(this.logicDeleteField, (Expression)this.deletedValue);
        } else {
            convertUpdate.update(this.logicDeleteField, this.deletedValue);
        }
        delete.convertUpdate(convertUpdate);
    }

    @Override
    protected void handleFilter(AbstractFilter<?> abstractFilter) {
        if (!abstractFilter.hasFilter(this.logicDeleteField)) {
            abstractFilter.eq(this.logicDeleteField, this.availableValue);
        }
    }

    @Override
    protected void handleOnFilter(Object joinParam, Supplier<List<Filter>> onFilters, Consumer<Filter> onMethod, String tableAs) {
        List<Filter> filters = onFilters.get();
        if (filters != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                String field = filter.getField();
                if (field == null || !FilterUtils.tableAsField("-", field).equals(this.logicDeleteField)) continue;
                return;
            }
        }
        onMethod.accept(Filter.AND);
        onMethod.accept(Filter.eq(this.logicDeleteField, this.availableValue).fieldAs(tableAs));
    }

    @Override
    protected void handleInsert(Class<?> entityClass, List<?> entityList, List<Map<String, Object>> fieldValueMapList) {
    }

    @Override
    public int sortIndex() {
        return -1;
    }
}

