/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.interceptor;

import cn.veasion.db.AbstractFilter;
import cn.veasion.db.base.Filter;
import cn.veasion.db.interceptor.EntityDaoInterceptor;
import cn.veasion.db.interceptor.EntityDaoInvocation;
import cn.veasion.db.query.AbstractJoinQuery;
import cn.veasion.db.query.AbstractQuery;
import cn.veasion.db.query.JoinQueryParam;
import cn.veasion.db.query.SubQuery;
import cn.veasion.db.query.SubQueryParam;
import cn.veasion.db.query.UnionQueryParam;
import cn.veasion.db.update.AbstractUpdate;
import cn.veasion.db.update.BatchEntityInsert;
import cn.veasion.db.update.Delete;
import cn.veasion.db.update.EntityInsert;
import cn.veasion.db.update.EntityUpdate;
import cn.veasion.db.update.JoinUpdateParam;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class AbstractInterceptor
implements EntityDaoInterceptor {
    private boolean handleQuery;
    private boolean handleUpdate;
    private boolean handleDelete;
    private boolean handleAbstractFilter;
    private boolean handleInsert;

    public AbstractInterceptor(boolean handleQuery, boolean handleUpdate, boolean handleDelete, boolean handleAbstractFilter, boolean handleInsert) {
        this.handleQuery = handleQuery;
        this.handleUpdate = handleUpdate;
        this.handleDelete = handleDelete;
        this.handleAbstractFilter = handleAbstractFilter;
        this.handleInsert = handleInsert;
    }

    @Override
    public <R> R intercept(EntityDaoInvocation<R> invocation) {
        Object[] args = invocation.getArgs();
        if (args != null && !this.skip()) {
            for (Object arg : args) {
                EntityInsert insert;
                if (arg instanceof AbstractQuery && this.handleQuery) {
                    this.handleQuery((AbstractQuery)arg);
                    continue;
                }
                if (arg instanceof AbstractUpdate && this.handleUpdate) {
                    this.handleUpdate((AbstractUpdate)arg);
                    continue;
                }
                if (arg instanceof Delete && this.handleDelete) {
                    if (this.containSkipClass(((Delete)arg).getEntityClass())) continue;
                    this.handleDelete((Delete)arg);
                    continue;
                }
                if (arg instanceof AbstractFilter) {
                    if (!this.handleAbstractFilter) continue;
                    this.handleAbstractFilter((AbstractFilter)arg);
                    continue;
                }
                if (arg instanceof BatchEntityInsert) {
                    if (this.containSkipClass(((BatchEntityInsert)arg).getEntityClass())) continue;
                    this.handleBatchInsert((BatchEntityInsert)arg);
                    continue;
                }
                if (!(arg instanceof EntityInsert) || !this.handleInsert || this.containSkipClass((insert = (EntityInsert)arg).getEntityClass())) continue;
                this.handleInsert(insert.getEntityClass(), Collections.singletonList(insert.getEntity()), Collections.singletonList(insert.getFieldValueMap()));
            }
        }
        return invocation.proceed();
    }

    protected abstract void handleDelete(Delete var1);

    protected abstract void handleInsert(Class<?> var1, List<?> var2, List<Map<String, Object>> var3);

    protected abstract void handleOnFilter(Object var1, Supplier<List<Filter>> var2, Consumer<Filter> var3, String var4);

    protected abstract void handleFilter(AbstractFilter<?> var1);

    protected boolean skip() {
        return false;
    }

    protected boolean containSkipClass(Class<?> clazz) {
        return false;
    }

    protected boolean containSkipClass(AbstractFilter<?> filter) {
        return filter != null && this.containSkipClass(filter.getEntityClass());
    }

    protected void handleQuery(AbstractQuery<?> query) {
        List<UnionQueryParam> unions;
        List<JoinQueryParam> joinList;
        if (query instanceof SubQuery) {
            this.handleQuery(((SubQuery)query).getSubQuery());
        }
        this.handleSelectSubQuery(query.getSelectSubQueryList());
        this.handleAbstractFilter(query);
        if (query instanceof AbstractJoinQuery && (joinList = ((AbstractJoinQuery)query).getJoinAll()) != null) {
            for (JoinQueryParam joinQueryParam : joinList) {
                AbstractJoinQuery<?> joinQuery = joinQueryParam.getJoinQuery();
                if (joinQuery instanceof SubQuery) {
                    this.handleQuery(((SubQuery)joinQuery).getSubQuery());
                    continue;
                }
                if (!this.containSkipClass(joinQuery)) {
                    this.handleSelectSubQuery(joinQuery.getSelectSubQueryList());
                    this.handleOnFilter(joinQueryParam, joinQueryParam::getOnFilters, joinQueryParam::on, joinQuery.getTableAs());
                }
                this.handleFilterSubQuery(joinQuery.getFilters());
            }
        }
        if ((unions = query.getUnions()) != null) {
            unions.stream().map(UnionQueryParam::getUnion).forEach(this::handleQuery);
        }
    }

    protected void handleUpdate(AbstractUpdate<?> update) {
        this.handleAbstractFilter(update);
        if (update instanceof EntityUpdate) {
            List<JoinUpdateParam> joinList = ((EntityUpdate)update).getJoinAll();
            if (joinList == null || joinList.isEmpty()) {
                return;
            }
            for (JoinUpdateParam joinUpdateParam : joinList) {
                EntityUpdate joinUpdate = joinUpdateParam.getJoinUpdate();
                if (!this.containSkipClass(joinUpdate)) {
                    this.handleOnFilter(joinUpdateParam, joinUpdateParam::getOnFilters, joinUpdateParam::on, joinUpdate.getTableAs());
                }
                this.handleFilterSubQuery(joinUpdate.getFilters());
            }
        }
    }

    protected void handleBatchInsert(BatchEntityInsert insert) {
        AbstractQuery<?> insertSelectQuery = insert.getInsertSelectQuery();
        if (insertSelectQuery != null) {
            if (this.handleQuery) {
                this.handleQuery(insertSelectQuery);
            }
        } else if (this.handleInsert) {
            this.handleInsert(insert.getEntityClass(), insert.getEntityList(), insert.getFieldValueMapList());
        }
    }

    protected void handleAbstractFilter(AbstractFilter<?> abstractFilter) {
        if (abstractFilter == null) {
            return;
        }
        if (this.containSkipClass(abstractFilter)) {
            return;
        }
        if (!(abstractFilter instanceof SubQuery)) {
            this.handleFilter(abstractFilter);
        }
        this.handleFilterSubQuery(abstractFilter.getFilters());
    }

    protected void handleSelectSubQuery(List<SubQueryParam> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SubQueryParam sub : list) {
            this.handleQuery(sub.getQuery());
        }
    }

    protected void handleFilterSubQuery(List<Filter> filters) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (Filter filter : filters) {
            if (!filter.isSpecial() || !(filter.getValue() instanceof SubQueryParam)) continue;
            this.handleQuery(((SubQueryParam)filter.getValue()).getQuery());
        }
    }
}

