/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.criteria;

import cn.veasion.db.DbException;
import cn.veasion.db.FilterException;
import cn.veasion.db.base.Filter;
import cn.veasion.db.base.Operator;
import cn.veasion.db.criteria.AutoCriteria;
import cn.veasion.db.criteria.JoinCriteria;
import cn.veasion.db.criteria.JoinCriteriaMulti;
import cn.veasion.db.criteria.LoadRelation;
import cn.veasion.db.criteria.QueryCriteria;
import cn.veasion.db.jdbc.EntityDao;
import cn.veasion.db.query.EQ;
import cn.veasion.db.query.EntityQuery;
import cn.veasion.db.query.JoinQueryParam;
import cn.veasion.db.utils.FieldUtils;
import cn.veasion.db.utils.FilterUtils;
import cn.veasion.db.utils.TypeUtils;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class QueryCriteriaConvert {
    public static final Pattern FIELD_PATTERN = Pattern.compile("[_0-9a-zA-Z.]+");
    private Object object;
    private EntityQuery query;
    private JoinCriteria[] array;
    private List<LoadRelation> loadRelations;
    private Set<Class<?>> joined = new HashSet();
    private Map<Class<?>, EntityQuery> joinClassMap = new HashMap();

    public QueryCriteriaConvert(Object object) {
        this(object, null);
    }

    public QueryCriteriaConvert(Object object, Class<?> entityClass) {
        Objects.requireNonNull(object, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.object = object;
        this.query = new EQ(entityClass, "t");
        this.handleFilters();
    }

    public EntityQuery getEntityQuery() {
        return this.query;
    }

    public boolean hasJoin(Class<?> clazz) {
        return this.joined.contains(clazz);
    }

    public boolean hasJoin(String tableName) {
        for (Class<?> clazz : this.joined) {
            if (!tableName.equalsIgnoreCase(TypeUtils.getTableName(clazz))) continue;
            return true;
        }
        return false;
    }

    public EntityQuery getJoinEntityQuery(Class<?> clazz) {
        return this.joinClassMap.get(clazz);
    }

    public EntityQuery getJoinEntityQuery(String tableName) {
        for (Map.Entry<Class<?>, EntityQuery> entry : this.joinClassMap.entrySet()) {
            if (!tableName.equalsIgnoreCase(TypeUtils.getTableName(entry.getKey()))) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<Class<?>, EntityQuery> getJoinClassMap() {
        return this.joinClassMap;
    }

    private void handleFilters() {
        JoinCriteriaMulti joinCriteriaMulti = this.object.getClass().getAnnotation(JoinCriteriaMulti.class);
        if (joinCriteriaMulti != null) {
            this.array = joinCriteriaMulti.value();
        }
        this.initJoinClassMap();
        Map<String, Field> fields = FieldUtils.fields(this.object.getClass());
        for (Field field : fields.values()) {
            QueryCriteria queryCriteria = field.getAnnotation(QueryCriteria.class);
            AutoCriteria autoCriteria = field.getAnnotation(AutoCriteria.class);
            LoadRelation loadRelation = field.getAnnotation(LoadRelation.class);
            Object value = null;
            if (loadRelation != null) {
                if (loadRelation.value() == Void.class || "".equals(loadRelation.resultClassField())) {
                    throw new DbException("@LoadRelation \u6ce8\u89e3\u4f7f\u7528\u65b9\u5f0f\u9519\u8bef\uff0c\u5b57\u6bb5: " + field.getName());
                }
                value = FieldUtils.getValue(this.object, field.getName(), true);
                if (value != null && !Boolean.FALSE.equals(value)) {
                    if (this.loadRelations == null) {
                        this.loadRelations = new ArrayList<LoadRelation>();
                    }
                    this.loadRelations.add(loadRelation);
                }
            }
            if (queryCriteria == null && autoCriteria == null) continue;
            if (value == null) {
                value = FieldUtils.getValue(this.object, field.getName(), true);
            }
            if (value == null) continue;
            if (queryCriteria != null) {
                this.handleQueryCriteria(field, queryCriteria, value);
                continue;
            }
            if (value instanceof Map) {
                this.handleAutoCriteria(autoCriteria, (Map)value);
                continue;
            }
            this.handleAutoCriteria(autoCriteria, Collections.singletonMap(field.getName(), value));
        }
    }

    private void handleAutoCriteria(AutoCriteria annotation, Map<String, Object> filters) {
        Class<?> relationClass = annotation.relation();
        for (Map.Entry<String, Object> entry : filters.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || annotation.skipEmpty() && QueryCriteriaConvert.isEmpty(value)) continue;
            if (!FIELD_PATTERN.matcher(key).matches() || key.length() > 30) {
                throw new FilterException("\u975e\u6cd5\u5b57\u6bb5\uff1a" + key);
            }
            if (relationClass != Void.class) {
                this.checkJoin(relationClass);
            }
            Operator operator = Operator.EQ;
            if (value instanceof Collection || value instanceof Object[]) {
                operator = Operator.IN;
            } else if (key.startsWith("start_")) {
                key = key.substring(6);
                operator = Operator.GTE;
            } else if (key.startsWith("end_")) {
                key = key.substring(4);
                operator = Operator.LTE;
            } else if (value instanceof String && (String.valueOf(value).startsWith("%") || String.valueOf(value).endsWith("%"))) {
                operator = Operator.LIKE;
            }
            if (value instanceof Date) {
                value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)value);
            }
            Filter filter = FilterUtils.getFilter(key, operator, value);
            if (relationClass != Void.class) {
                filter.fieldAs(this.joinClassMap.get(relationClass).getTableAs());
            }
            this.query.addFilter(filter);
        }
    }

    private void handleQueryCriteria(Field field, QueryCriteria annotation, Object value) {
        String[] orFields;
        if (annotation.skipEmpty() && QueryCriteriaConvert.isEmpty(value)) {
            return;
        }
        String fieldName = "".equals(annotation.field()) ? field.getName() : annotation.field();
        Operator operator = annotation.value();
        Class<?> relationClass = annotation.relation();
        if (relationClass != Void.class) {
            this.checkJoin(relationClass);
        }
        if ((orFields = annotation.orFields()).length > 0) {
            this.query.addFilter(Filter.leftBracket());
            for (int i = 0; i < orFields.length; ++i) {
                Filter filter = FilterUtils.getFilter(orFields[i], operator, value);
                if (relationClass != Void.class) {
                    filter.fieldAs(this.joinClassMap.get(relationClass).getTableAs());
                }
                this.query.addFilter(filter);
                if (i >= orFields.length - 1) continue;
                this.query.addFilter(Filter.or());
            }
            this.query.addFilter(Filter.rightBracket());
        } else {
            Filter filter = FilterUtils.getFilter(fieldName, operator, value);
            if (relationClass != Void.class) {
                filter.fieldAs(this.joinClassMap.get(relationClass).getTableAs());
            }
            this.query.addFilter(filter);
        }
    }

    public <E> void handleResultLoadRelation(EntityDao<?, ?> entityDao, List<E> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Class<?> resultClass = list.get(0).getClass();
        Map<Field, Class<?>> fieldClassMap = this.loadResultRelation(resultClass);
        if (fieldClassMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Field, Class<?>> entry : fieldClassMap.entrySet()) {
            int i;
            Field field = entry.getKey();
            Class<?> clazz = entry.getValue();
            HashMap joinClassMap = new HashMap();
            HashSet joined = new HashSet();
            QueryCriteriaConvert.initJoinClassMap(this.array, new EQ(this.query.getEntityClass(), "t"), joinClassMap);
            JoinCriteria joinCriteria = QueryCriteriaConvert.checkJoin(this.array, joinClassMap, joined, clazz);
            if (!joined.contains(clazz) || joinCriteria == null) {
                throw new DbException("@JoinCriteria \u4e2d\u672a\u627e\u5230\u5173\u8054\u7c7b\uff1a" + clazz.getName());
            }
            EntityQuery entityQuery = (EntityQuery)joinClassMap.get(joinCriteria.join());
            String[] onFields = joinCriteria.onFields();
            for (int i2 = 0; i2 < onFields.length; i2 += 2) {
                entityQuery.selectExpression("${" + onFields[i2 + 1] + "}", "mainField" + (i2 + 2) / 2, new Object[0]);
                ArrayList<Object> values = new ArrayList<Object>(list.size());
                for (Iterator<Map<String, Object>> o : list) {
                    values.add(FieldUtils.getValue(o, onFields[i2], true));
                }
                entityQuery.in(onFields[i2 + 1], values);
            }
            ((EntityQuery)joinClassMap.get(clazz)).selectAll();
            List<Map<String, Object>> resultList = entityDao.listForMap(entityQuery);
            StringBuilder sb = new StringBuilder();
            HashMap<String, List> keyList = new HashMap<String, List>(resultList.size());
            for (Map<String, Object> map : resultList) {
                sb.setLength(0);
                for (i = 0; i < onFields.length; i += 2) {
                    sb.append("_").append(map.get("mainField" + (i + 2) / 2));
                }
                keyList.compute(sb.toString(), (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<Map>();
                    }
                    v.add(map);
                    return v;
                });
            }
            try {
                Iterator<Map<String, Object>> o;
                o = list.iterator();
                while (o.hasNext()) {
                    Map<String, Object> o2 = o.next();
                    sb.setLength(0);
                    for (i = 0; i < onFields.length; i += 2) {
                        sb.append("_").append(FieldUtils.getValue(o2, onFields[i], true));
                    }
                    this.convert(o2, field, (List)keyList.get(sb.toString()));
                }
            }
            catch (Exception e) {
                throw new DbException("@JoinCriteria \u5b57\u6bb5\u7c7b\u578b\u8d4b\u503c\u5f02\u5e38\uff1a" + field.getType().getName() + "." + field.getName(), e);
            }
        }
    }

    private void convert(Object obj, Field field, List<Map<String, Object>> values) throws Exception {
        Class<?> type = field.getType();
        AbstractCollection val = null;
        if (List.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type)) {
            if (values == null || values.isEmpty()) {
                val = Set.class.isAssignableFrom(type) ? new HashSet() : new ArrayList();
            } else {
                List<Class<?>> classes = FieldUtils.fieldActualType(field);
                if (classes == null || classes.isEmpty()) {
                    val = Set.class.isAssignableFrom(type) ? new HashSet<Map<String, Object>>(values) : values;
                } else {
                    AbstractCollection list = Set.class.isAssignableFrom(type) ? new HashSet() : new ArrayList();
                    for (Map<String, Object> value : values) {
                        list.add(TypeUtils.map2Obj(value, classes.get(0)));
                    }
                    val = list;
                }
            }
        } else if (Map.class.isAssignableFrom(type)) {
            if (values != null && values.size() > 0) {
                if (values.size() > 1) {
                    throw new DbException("@LoadRelation \u52a0\u8f7d\u6709\u591a\u4e2a\u5bf9\u8c61\uff1a" + obj.getClass().getName() + "." + field.getName());
                }
                val = values.get(0);
            }
        } else if (values != null && values.size() > 0) {
            if (values.size() > 1) {
                throw new DbException("@LoadRelation \u52a0\u8f7d\u6709\u591a\u4e2a\u5bf9\u8c61\uff1a" + obj.getClass().getName() + "." + field.getName());
            }
            val = TypeUtils.map2Obj(values.get(0), type);
        }
        field.setAccessible(true);
        field.set(obj, val);
    }

    private Map<Field, Class<?>> loadResultRelation(Class<?> resultClass) {
        HashMap result = new HashMap();
        Map<String, Field> fields = FieldUtils.fields(resultClass);
        if (this.loadRelations != null) {
            for (LoadRelation loadRelation : this.loadRelations) {
                Field field = fields.get(loadRelation.resultClassField());
                if (field == null) {
                    throw new DbException("@LoadRelation \u6ce8\u89e3resultClassField\u5b57\u6bb5" + loadRelation.resultClassField() + "\u5728" + resultClass.getName() + "\u4e2d\u4e0d\u5b58\u5728");
                }
                if (!this.joinClassMap.containsKey(loadRelation.value())) {
                    throw new DbException("@LoadRelation \u6ce8\u89e3 value = " + loadRelation.value().getName() + "\u672a\u5728\u7c7b @JoinCriteria \u4e2d\u5b9a\u4e49");
                }
                result.put(field, loadRelation.value());
            }
        }
        for (Field field : fields.values()) {
            LoadRelation loadRelation = field.getAnnotation(LoadRelation.class);
            if (loadRelation == null) continue;
            if (loadRelation.value() == Void.class) {
                throw new DbException("@LoadRelation\u6ce8\u89e3\u4f7f\u7528\u9519\u8bef\uff1a" + resultClass.getName() + "." + field.getName());
            }
            if (!this.joinClassMap.containsKey(loadRelation.value())) continue;
            result.put(field, loadRelation.value());
        }
        return result;
    }

    private void initJoinClassMap() {
        QueryCriteriaConvert.initJoinClassMap(this.array, this.query, this.joinClassMap);
        if (this.array != null) {
            for (JoinCriteria joinCriteria : this.array) {
                if (!joinCriteria.staticJoin()) continue;
                this.checkJoin(joinCriteria.join());
            }
        }
    }

    private void checkJoin(Class<?> joinClass) {
        QueryCriteriaConvert.checkJoin(this.array, this.joinClassMap, this.joined, joinClass);
    }

    private static void initJoinClassMap(JoinCriteria[] array, EntityQuery query, Map<Class<?>, EntityQuery> joinClassMap) {
        if (array == null || array.length == 0) {
            return;
        }
        for (JoinCriteria joinCriteria : array) {
            Class<?> join = joinCriteria.join();
            if (join == Void.class) continue;
            joinClassMap.put(join, new EQ(join, FieldUtils.firstCase(join.getSimpleName(), true)));
        }
        joinClassMap.put(Void.class, query);
    }

    private static JoinCriteria checkJoin(JoinCriteria[] array, Map<Class<?>, EntityQuery> joinClassMap, Set<Class<?>> joined, Class<?> joinClass) {
        if (joined.contains(joinClass)) {
            return null;
        }
        if (array == null || array.length == 0) {
            throw new DbException("@JoinCriteriaMulti \u4e2d\u5173\u8054\u7c7b\u672a\u627e\u5230\uff1a" + joinClass.getSimpleName());
        }
        JoinCriteria firstJoinCriteria = null;
        HashSet<JoinCriteria> joinCriteriaSet = new HashSet<JoinCriteria>(Arrays.asList(array));
        block0: do {
            for (JoinCriteria joinCriteria : joinCriteriaSet) {
                if (joinClass != joinCriteria.join()) continue;
                EntityQuery main = joinClassMap.get(joinCriteria.value());
                EntityQuery join = joinClassMap.get(joinCriteria.join());
                JoinQueryParam joinQueryParam = main.join(joinCriteria.joinType(), join);
                joined.add(joinClass);
                String[] onFields = joinCriteria.onFields();
                for (int i = 0; i < onFields.length; i += 2) {
                    joinQueryParam.on(onFields[i], onFields[i + 1]);
                }
                joinClass = joinCriteria.value();
                joinCriteriaSet.remove(joinCriteria);
                firstJoinCriteria = joinCriteria;
                continue block0;
            }
        } while (joinClass != Void.class && !joined.contains(joinClass));
        return firstJoinCriteria;
    }

    private static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return "".equals(value);
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Object[]) {
            return ((Object[])value).length == 0;
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        return false;
    }
}

