/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.base;

import cn.veasion.db.FilterException;
import cn.veasion.db.base.Expression;
import cn.veasion.db.base.Operator;
import cn.veasion.db.query.SubQueryParam;
import cn.veasion.db.utils.FilterUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class Filter {
    public static Filter AND = Filter.build("AND");
    public static Filter OR = Filter.build("OR");
    public static Filter LEFT_BRACKET = Filter.build("(");
    public static Filter RIGHT_BRACKET = Filter.build(")");
    private String field;
    private Operator operator;
    private String sql;
    private Object value;
    private boolean special;

    public static Filter eq(String field, Object value) {
        return Filter.build(field, Operator.EQ, value);
    }

    public static Filter neq(String field, Object value) {
        return Filter.build(field, Operator.NEQ, value);
    }

    public static Filter gt(String field, Object value) {
        return Filter.build(field, Operator.GT, value);
    }

    public static Filter gte(String field, Object value) {
        return Filter.build(field, Operator.GTE, value);
    }

    public static Filter lt(String field, Object value) {
        return Filter.build(field, Operator.LT, value);
    }

    public static Filter lte(String field, Object value) {
        return Filter.build(field, Operator.LTE, value);
    }

    public static Filter in(String field, Collection<?> value) {
        return Filter.inOrNotIn(field, Operator.IN, value);
    }

    public static Filter in(String field, Object[] value) {
        return Filter.inOrNotIn(field, Operator.IN, value);
    }

    public static Filter notIn(String field, Collection<?> value) {
        return Filter.inOrNotIn(field, Operator.NOT_IN, value);
    }

    public static Filter notIn(String field, Object[] value) {
        return Filter.inOrNotIn(field, Operator.NOT_IN, value);
    }

    public static Filter like(String field, Object value) {
        if (value == null) {
            return null;
        }
        return Filter.build(field, Operator.LIKE, Filter.like(value, true, true));
    }

    public static Filter likeLeft(String field, Object value) {
        if (value == null) {
            return null;
        }
        return Filter.build(field, Operator.LIKE, Filter.like(value, true, false));
    }

    public static Filter likeRight(String field, Object value) {
        if (value == null) {
            return null;
        }
        return Filter.build(field, Operator.LIKE, Filter.like(value, false, true));
    }

    public static Filter isNull(String field) {
        return Filter.build(field, Operator.NULL);
    }

    public static Filter isNotNull(String field) {
        return Filter.build(field, Operator.NOT_NULL);
    }

    public static Filter between(String field, Object value1, Object value2) {
        return Filter.build(field, Operator.BETWEEN, new Object[]{value1, value2}, Operator.BETWEEN.getOpt().concat(" ? AND ?"));
    }

    public static Filter subQuery(String field, Operator operator, SubQueryParam subQueryParam) {
        return Filter.build(field, operator, Objects.requireNonNull(subQueryParam), null).special();
    }

    public static Filter expression(String field, Operator operator, String expression, Object ... values) {
        return Filter.expression(field, operator, Expression.filter(expression, values));
    }

    public static Filter expression(String field, Operator operator, Expression expression) {
        return Filter.build(field, operator, expression, null).special();
    }

    public static Filter and() {
        return AND;
    }

    public static Filter or() {
        return OR;
    }

    public static Filter leftBracket() {
        return LEFT_BRACKET;
    }

    public static Filter rightBracket() {
        return RIGHT_BRACKET;
    }

    private static Filter inOrNotIn(String field, Operator operator, Object value) {
        int len;
        int n = len = value instanceof Collection ? ((Collection)value).size() : ((Object[])value).length;
        if (len == 0) {
            throw new FilterException(field + " " + operator.opt + " \u7a7a\u96c6\u5408");
        }
        Object[] array = new String[len];
        Arrays.fill(array, "?");
        return Filter.build(field, operator, value, operator.getOpt().concat(" (").concat(String.join((CharSequence)",", (CharSequence[])array)).concat(")"));
    }

    private static Filter build(String sql) {
        Filter filter = new Filter();
        filter.sql = sql;
        return filter;
    }

    private static Filter build(String field, Operator operator) {
        return Filter.build(field, operator, null, operator.getOpt());
    }

    private static Filter build(String field, Operator operator, Object value) {
        return Filter.build(field, operator, value, operator.getOpt().concat(" ?"));
    }

    private static Filter build(String field, Operator operator, Object value, String sql) {
        Filter filter = new Filter();
        filter.field = field;
        filter.operator = operator;
        filter.value = value;
        filter.sql = sql;
        return filter;
    }

    private static String like(Object v, boolean left, boolean right) {
        String value;
        String string = value = v != null ? v.toString() : null;
        if (left && right) {
            return "%" + value + "%";
        }
        if (left) {
            return "%" + value;
        }
        if (right) {
            return value + "%";
        }
        return value;
    }

    private Filter() {
    }

    public Filter fieldAs(String tableAs) {
        this.field = FilterUtils.tableAsField(tableAs, this.field);
        return this;
    }

    public String getField() {
        return this.field;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getSql() {
        return this.sql;
    }

    public Object getValue() {
        return this.value;
    }

    private Filter special() {
        this.special = true;
        return this;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public String toString() {
        if (this.operator != null && this.value != null) {
            return this.field + " " + this.operator.opt + " " + this.value;
        }
        if (this.operator != null) {
            return this.field + " " + this.operator.opt;
        }
        return this.sql;
    }
}

