/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db;

import cn.veasion.db.base.Expression;
import cn.veasion.db.base.Filter;
import cn.veasion.db.base.Operator;
import cn.veasion.db.query.SubQueryParam;
import cn.veasion.db.utils.FilterUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractFilter<T extends AbstractFilter<?>> {
    protected boolean checked;
    private Class<?> entityClass;
    private List<Filter> filters;
    private boolean skipNullValueFilter;

    public T eq(String field, Object value) {
        return this.addFilter(Filter.eq(field, value));
    }

    public T neq(String field, Object value) {
        return this.addFilter(Filter.neq(field, value));
    }

    public T gt(String field, Object value) {
        return this.addFilter(Filter.gt(field, value));
    }

    public T gte(String field, Object value) {
        return this.addFilter(Filter.gte(field, value));
    }

    public T lt(String field, Object value) {
        return this.addFilter(Filter.lt(field, value));
    }

    public T lte(String field, Object value) {
        return this.addFilter(Filter.lte(field, value));
    }

    public T in(String field, Collection<?> value) {
        return this.addFilter(Filter.in(field, value));
    }

    public T in(String field, Object[] value) {
        return this.addFilter(Filter.in(field, value));
    }

    public T notIn(String field, Collection<?> value) {
        return this.addFilter(Filter.notIn(field, value));
    }

    public T notIn(String field, Object[] value) {
        return this.addFilter(Filter.notIn(field, value));
    }

    public T like(String field, Object value) {
        return this.addFilter(Filter.like(field, value));
    }

    public T likeLeft(String field, Object value) {
        return this.addFilter(Filter.likeLeft(field, value));
    }

    public T likeRight(String field, Object value) {
        return this.addFilter(Filter.likeRight(field, value));
    }

    public T isNull(String field) {
        return this.addFilter(Filter.isNull(field));
    }

    public T isNotNull(String field) {
        return this.addFilter(Filter.isNotNull(field));
    }

    public T between(String field, Object value1, Object value2) {
        return this.addFilter(Filter.between(field, value1, value2));
    }

    public T andBracket(Filter ... filters) {
        this.addFilter(Filter.leftBracket());
        this.addFilters(filters);
        return this.addFilter(Filter.rightBracket());
    }

    public T exists(SubQueryParam subQueryParam) {
        return this.addFilter(Filter.subQuery(null, Operator.EXISTS, subQueryParam));
    }

    public T notExists(SubQueryParam subQueryParam) {
        return this.addFilter(Filter.subQuery(null, Operator.NOT_EXISTS, subQueryParam));
    }

    public T filterSubQuery(String field, Operator operator, SubQueryParam subQueryParam) {
        return this.addFilter(Filter.subQuery(field, operator, subQueryParam));
    }

    public T filterExpression(String field, Operator operator, String expression, Object ... values) {
        return this.filterExpression(field, operator, Expression.filter(expression, values));
    }

    public T filterExpression(String field, Operator operator, Expression expression) {
        return this.addFilters(Filter.expression(field, operator, expression));
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public boolean isSkipNullValueFilter() {
        return this.skipNullValueFilter;
    }

    public T setSkipNullValueFilter(boolean skipNullValueFilter) {
        this.skipNullValueFilter = skipNullValueFilter;
        return this.getSelf();
    }

    public T addFilter(Filter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        Objects.requireNonNull(filter, "\u8fc7\u6ee4\u5668\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.isSkipNullValueFilter() || this.isSkipNullValueFilter() && FilterUtils.hasFilter(filter)) {
            this.filters.add(this.handleFilter(filter));
            this.checkFilter();
        }
        return this.getSelf();
    }

    public boolean hasFilter(String field) {
        if (!this.hasFilters()) {
            return false;
        }
        field = this.handleFilter(Filter.eq(field, null)).getField();
        for (Filter filter : this.filters) {
            if (!Objects.equals(filter.getField(), field)) continue;
            return true;
        }
        return false;
    }

    public List<Filter> getFilters(String field) {
        if (!this.hasFilters()) {
            return Collections.emptyList();
        }
        String _field = this.handleFilter(Filter.eq(field, null)).getField();
        return this.filters.stream().filter(filter -> Objects.equals(filter.getField(), _field)).collect(Collectors.toList());
    }

    public Filter removeFilter(String field) {
        field = this.handleFilter(Filter.eq(field, null)).getField();
        if (this.filters != null && this.filters.size() > 0) {
            for (Filter filter : this.filters) {
                if (!Objects.equals(filter.getField(), field)) continue;
                this.filters.remove(filter);
                this.checkFilter();
                return filter;
            }
        }
        return null;
    }

    public T addFilters(Filter ... filters) {
        for (Filter filter : filters) {
            this.addFilter(filter);
        }
        return this.getSelf();
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public void check(Class<?> mainEntityClass) {
        if (this.entityClass == null) {
            this.setEntityClass(mainEntityClass);
        }
        this.checked = true;
        AbstractFilter.checkFilter(mainEntityClass, this.filters, this.skipNullValueFilter);
    }

    private void checkFilter() {
        if (this.checked) {
            AbstractFilter.checkFilter(this.entityClass, this.filters, this.skipNullValueFilter);
        }
    }

    public static void checkFilter(Class<?> mainEntityClass, List<Filter> filters, boolean ignoreNullValueFilter) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        boolean preIsJoin = true;
        for (int i = 0; i < filters.size(); ++i) {
            Filter filter = FilterUtils.checkFilter(filters.get(i));
            if (filter != null && filter.isSpecial() && filter.getValue() instanceof SubQueryParam) {
                ((SubQueryParam)filter.getValue()).getQuery().check(mainEntityClass);
            }
            if (ignoreNullValueFilter && !FilterUtils.hasFilter(filter)) {
                filters.remove(i--);
                continue;
            }
            if (Filter.AND.equals(filter) || Filter.OR.equals(filter)) {
                if (preIsJoin) {
                    filters.remove(i--);
                }
                preIsJoin = true;
                continue;
            }
            if (!preIsJoin) {
                if (Filter.RIGHT_BRACKET.equals(filter)) continue;
                filters.add(i++, Filter.AND);
            } else {
                preIsJoin = false;
            }
            if (!Filter.LEFT_BRACKET.equals(filter)) continue;
            preIsJoin = true;
        }
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    protected abstract Filter handleFilter(Filter var1);

    protected abstract T getSelf();
}

