/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.spring;

import cn.veasion.db.base.JdbcTypeEnum;
import cn.veasion.db.jdbc.DataSourceProvider;
import cn.veasion.db.jdbc.EntityDao;
import cn.veasion.db.mybatis.MybatisEntityDao;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.BiFunction;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class DefaultDataSourceProvider
implements DataSourceProvider {
    private static BiFunction<EntityDao<?, ?>, JdbcTypeEnum, DataSource> DATA_SOURCE_BI_FUNCTION;

    public static void setDataSourceProvider(BiFunction<EntityDao<?, ?>, JdbcTypeEnum, DataSource> function) {
        DATA_SOURCE_BI_FUNCTION = function;
    }

    public DataSource getDataSource(EntityDao<?, ?> entityDao, JdbcTypeEnum jdbcTypeEnum) {
        DataSource dataSource = null;
        if (DATA_SOURCE_BI_FUNCTION != null) {
            dataSource = DATA_SOURCE_BI_FUNCTION.apply(entityDao, jdbcTypeEnum);
        }
        if (dataSource == null && entityDao instanceof MybatisEntityDao) {
            dataSource = ((MybatisEntityDao)entityDao).getDataSource();
        }
        return dataSource;
    }

    public Connection getConnection(DataSource dataSource) throws SQLException {
        return DataSourceUtils.getConnection((DataSource)dataSource);
    }

    public boolean autoClose() {
        return false;
    }
}

