/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.db.mybatis;

import cn.veasion.db.jdbc.EntityDao;
import cn.veasion.db.mybatis.EntityDaoProxy;
import cn.veasion.db.mybatis.MybatisEntityDao;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.mybatis.spring.mapper.MapperFactoryBean;

public class MybatisMapperFactoryBean<T>
extends MapperFactoryBean<T> {
    public MybatisMapperFactoryBean() {
    }

    public MybatisMapperFactoryBean(Class<T> mapperInterface) {
        super(mapperInterface);
    }

    public T getObject() throws Exception {
        Object object = super.getObject();
        Class mapperInterface = this.getMapperInterface();
        if (EntityDao.class.isAssignableFrom(mapperInterface)) {
            MybatisEntityDao mybatisEntityDao = new MybatisEntityDao();
            mybatisEntityDao.setMapperInterface(mapperInterface);
            mybatisEntityDao.setDataSource(this.getSqlSession().getConfiguration().getEnvironment().getDataSource());
            EntityDaoProxy entityDaoProxy = new EntityDaoProxy(object, (EntityDao<?, ?>)mybatisEntityDao);
            return (T)Proxy.newProxyInstance(mapperInterface.getClassLoader(), new Class[]{mapperInterface}, (InvocationHandler)entityDaoProxy);
        }
        return (T)object;
    }
}

