/*
 * Decompiled with CFR 0.152.
 */
package cn.veasion.eval;

import cn.veasion.eval.EvalObjectUtils;
import cn.veasion.eval.EvalParser;
import cn.veasion.eval.TemplateParser;
import cn.veasion.eval.tpl.BlockTemplateTree;
import cn.veasion.eval.tpl.ForTemplateTree;
import cn.veasion.eval.tpl.IfTemplateTree;
import cn.veasion.eval.tpl.TemplateTree;
import cn.veasion.eval.tpl.TokenEnum;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class TemplateParserUtils {
    public static String parseTemplate(Object object, InputStream inputStream) throws Exception {
        return TemplateParserUtils.parseTemplate(object, inputStream, StandardCharsets.UTF_8);
    }

    public static String parseTemplate(Object object, InputStream inputStream, Charset encoding) throws Exception {
        TemplateParser parser = new TemplateParser(inputStream, encoding);
        List<TemplateTree> treeList = parser.parse();
        EvalParser evalParser = new EvalParser(new StringReader(""));
        evalParser.setVarTrace(false);
        evalParser.setObject(object);
        StringBuilder sb = new StringBuilder();
        TemplateParserUtils.parseTemplate(object, evalParser, sb, treeList);
        return sb.toString();
    }

    private static void parseTemplate(Object object, EvalParser evalParser, StringBuilder sb, List<TemplateTree> treeList) throws Exception {
        if (treeList == null || treeList.isEmpty()) {
            return;
        }
        List<TemplateTree> list = TemplateParserUtils.merge(treeList);
        for (TemplateTree templateTree : list) {
            evalParser.setObject(object);
            TokenEnum tokenType = templateTree.getTokenType();
            if (TokenEnum.STRING.equals((Object)tokenType) || TokenEnum.TRIM.equals((Object)tokenType)) {
                sb.append(templateTree.getText());
                continue;
            }
            if (TokenEnum.EVAL.equals((Object)tokenType)) {
                Object result = evalParser.eval(templateTree.getText());
                if (result == null) continue;
                sb.append(result);
                continue;
            }
            if (templateTree instanceof IfTemplateTree) {
                TemplateParserUtils.ifTemplateTree(object, evalParser, sb, (IfTemplateTree)templateTree);
                continue;
            }
            if (!(templateTree instanceof ForTemplateTree)) continue;
            TemplateParserUtils.forTemplate(object, evalParser, sb, (ForTemplateTree)templateTree);
        }
    }

    private static void forTemplate(Object object, EvalParser evalParser, StringBuilder sb, ForTemplateTree templateTree) throws Exception {
        Object evalResult = evalParser.eval(templateTree.getLeft());
        if (evalResult == null) {
            return;
        }
        TemplateParserUtils.appendPre(sb, templateTree);
        HashMap<String, Object> env = new HashMap<String, Object>();
        Function<String, Object> function = key -> {
            if (env.containsKey(key)) {
                return env.get(key);
            }
            return EvalObjectUtils.parseObject(object, key);
        };
        evalParser.setObject(function);
        if (evalResult instanceof Map) {
            Map map = (Map)evalResult;
            for (Map.Entry entry : map.entrySet()) {
                env.put(templateTree.getRight1(), entry.getKey());
                if (templateTree.getRight2() != null && !"".equals(templateTree.getRight2())) {
                    env.put(templateTree.getRight2(), entry.getValue());
                }
                TemplateParserUtils.parseTemplate(function, evalParser, sb, templateTree.getChildren());
            }
        } else if (evalResult instanceof Iterable) {
            int index = 0;
            for (Object obj : (Iterable)evalResult) {
                boolean one;
                boolean bl = one = templateTree.getRight2() == null || "".equals(templateTree.getRight2());
                if (one) {
                    env.put(templateTree.getRight1(), obj);
                } else {
                    env.put(templateTree.getRight1(), index++);
                    env.put(templateTree.getRight2(), obj);
                }
                TemplateParserUtils.parseTemplate(function, evalParser, sb, templateTree.getChildren());
            }
        } else {
            throw new RuntimeException("for > " + templateTree.getLeft() + " \u53d8\u91cf\u7c7b\u578b\u4e0d\u652f\u6301\u5faa\u73af\u904d\u5386");
        }
        TemplateParserUtils.appendEnd(sb, templateTree);
    }

    private static void ifTemplateTree(Object object, EvalParser evalParser, StringBuilder sb, IfTemplateTree templateTree) throws Exception {
        Object evalResult = evalParser.eval(templateTree.getEval());
        boolean ifResult = EvalObjectUtils.isTrue(evalResult);
        if (ifResult) {
            TemplateParserUtils.appendPre(sb, templateTree);
            TemplateParserUtils.parseTemplate(object, evalParser, sb, templateTree.getChildren());
        }
        IfTemplateTree elseIfTree = templateTree.getElseIfTree();
        if (!ifResult && elseIfTree != null && (ifResult = EvalObjectUtils.isTrue(evalResult = evalParser.eval(elseIfTree.getEval())))) {
            TemplateParserUtils.appendPre(sb, elseIfTree);
            TemplateParserUtils.parseTemplate(object, evalParser, sb, elseIfTree.getChildren());
        }
        IfTemplateTree elseTree = templateTree.getElseTree();
        if (!ifResult && elseTree != null) {
            TemplateParserUtils.appendPre(sb, elseTree);
            TemplateParserUtils.parseTemplate(object, evalParser, sb, elseTree.getChildren());
        }
        if (ifResult || elseTree != null) {
            TemplateParserUtils.appendEnd(sb, templateTree);
        }
    }

    private static void appendPre(StringBuilder sb, BlockTemplateTree templateTree) {
        String pre = templateTree.pre();
        if (pre != null) {
            sb.append(pre);
        }
    }

    private static void appendEnd(StringBuilder sb, BlockTemplateTree templateTree) {
        String end = templateTree.end();
        if (end != null) {
            sb.append(end);
        }
    }

    private static List<TemplateTree> merge(List<TemplateTree> treeList) {
        if (treeList == null || treeList.isEmpty()) {
            return treeList;
        }
        ArrayList<TemplateTree> result = new ArrayList<TemplateTree>();
        for (int i = 0; i < treeList.size(); ++i) {
            TemplateTree tree = treeList.get(i);
            if (TokenEnum.STRING.equals((Object)tree.getTokenType())) {
                TemplateTree temp;
                int lastIndex = i;
                StringBuilder sb = new StringBuilder();
                int j = i;
                while (j < treeList.size() && TokenEnum.STRING.equals((Object)(temp = treeList.get(j)).getTokenType())) {
                    lastIndex = j++;
                    sb.append(temp.getText());
                }
                i = lastIndex;
                result.add(TemplateTree.build(TokenEnum.STRING, sb.toString()));
                continue;
            }
            result.add(tree);
        }
        return result;
    }
}

