/* EvalParser.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. EvalParser.java */
package cn.veasion.eval;
import java.util.Map;
import java.util.HashMap;
import java.util.Objects;
import java.io.StringReader;
import java.util.function.BiFunction;
public class EvalParser implements EvalParserConstants {
    private Object object;
    private boolean varTrace = true;
    private Map<String, Object> varMap = new HashMap<>();

    public void setObject(Object object) {
        this.object = object;
        if (varMap.size() > 0) {
            this.varMap = new HashMap<>();
        }
    }

    public void setVarTrace(boolean varTrace) {
        this.varTrace = varTrace;
    }

    public Map<String, Object> getVarMap() {
        return varMap;
    }

    public Object eval(String eval) throws Exception {
        return eval(null, eval);
    }

    public Object eval(Object object, String eval) throws Exception {
        if (object != null) {
            setObject(object);
        }
        ReInit(new StringReader(eval));
        return eval();
    }

    public String evalReplace(Object object, String str) throws Exception {
        return evalReplace(object, str, "${", "}");
    }

    public String evalReplace(Object object, String str, String prefix, String suffix) throws Exception {
        setObject(object);
        return EvalObjectUtils.evalReplace(object, str, prefix, suffix, new BiFunction<Object, String, Object>() {
            @Override
            public Object apply(Object o, String s) {
                try {
                    ReInit(new StringReader(s));
                    return eval();
                } catch (Exception e) {
                    throw new RuntimeException("\u89e3\u6790\u201c"+ s +"\u201d\u5f02\u5e38", e);
                }
            }
        });
    }

    private void putVar(Token token, Token endToken, Object val) {
        if (!varTrace) return;
        if (token == endToken || endToken == null) {
            varMap.put(token.image, val);
        } else {
            StringBuilder sb = new StringBuilder();
            appendToken(sb, token, endToken);
            varMap.put(sb.toString(), val);
        }
    }

    private void appendToken(StringBuilder sb, Token token, Token endToken) {
        sb.append(token.image);
        if (token == endToken || token.next == null) {
            return;
        }
        appendToken(sb, token.next, endToken);
    }

  final public Object eval() throws ParseException {Object obj;
    obj = Expression();
    jj_consume_token(0);
{if ("" != null) return obj;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Object Expression() throws ParseException {Object ret;
    ret = ConditionalExpression();
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Object ConditionalExpression() throws ParseException {Object ret, left, right;
    ret = ConditionalOrExpression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case QUESTION_MARK:{
      jj_consume_token(QUESTION_MARK);
      left = Expression();
      jj_consume_token(COLON);
      right = Expression();
ret = EvalObjectUtils.isTrue(ret) ? left : right;
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Object ConditionalOrExpression() throws ParseException {Object ret, temp;
    ret = ConditionalAndExpression();
    label_1:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case OR:{
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      jj_consume_token(OR);
      temp = ConditionalAndExpression();
ret = EvalObjectUtils.isTrue(ret) || EvalObjectUtils.isTrue(temp);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Object ConditionalAndExpression() throws ParseException {Object ret, temp;
    ret = ConditionalEvalExpression();
    label_2:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case AND:{
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      jj_consume_token(AND);
      temp = ConditionalEvalExpression();
ret = EvalObjectUtils.isTrue(ret) && EvalObjectUtils.isTrue(temp);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Object ConditionalEvalExpression() throws ParseException {Object ret, temp;
    ret = NotExpression();
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case EQ:
    case NEQ:
    case GT:
    case GTE:
    case LT:
    case LTE:{
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
        temp = NotExpression();
ret = EvalObjectUtils.equals(ret, temp);
        break;
        }
      case NEQ:{
        jj_consume_token(NEQ);
        temp = NotExpression();
ret = !EvalObjectUtils.equals(ret, temp);
        break;
        }
      case GT:{
        jj_consume_token(GT);
        temp = NotExpression();
ret = EvalObjectUtils.compareTo(ret, temp) > 0;
        break;
        }
      case GTE:{
        jj_consume_token(GTE);
        temp = NotExpression();
ret = EvalObjectUtils.compareTo(ret, temp) >= 0;
        break;
        }
      case LT:{
        jj_consume_token(LT);
        temp = NotExpression();
ret = EvalObjectUtils.compareTo(ret, temp) < 0;
        break;
        }
      case LTE:{
        jj_consume_token(LTE);
        temp = NotExpression();
ret = EvalObjectUtils.compareTo(ret, temp) <= 0;
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Object NotExpression() throws ParseException {Object ret, temp;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case BANG:{
      jj_consume_token(BANG);
      ret = EvalExpression();
ret = !EvalObjectUtils.isTrue(ret);
      break;
      }
    case QUOTATION:
    case LPAREN:
    case TRUE:
    case FALSE:
    case NULL:
    case NUMBER:
    case VAR:{
      ret = EvalExpression();
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Object EvalExpression() throws ParseException {Object ret; Token token;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case TRUE:{
      jj_consume_token(TRUE);
ret = true;
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
ret = false;
      break;
      }
    case NULL:{
      jj_consume_token(NULL);
ret = null;
      break;
      }
    case NUMBER:{
      token = jj_consume_token(NUMBER);
ret = token.image;
      break;
      }
    default:
      jj_la1[6] = jj_gen;
      if (jj_2_1(2)) {
        jj_consume_token(QUOTATION);
        token = jj_consume_token(VAR);
        jj_consume_token(QUOTATION);
ret = token.image;
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case QUOTATION:{
          jj_consume_token(QUOTATION);
          token = jj_consume_token(NUMBER);
          jj_consume_token(QUOTATION);
ret = token.image;
          break;
          }
        case VAR:{
          token = jj_consume_token(VAR);
          ret = evalVar(object, token.image);
putVar(token, getToken(0), ret);
          break;
          }
        case LPAREN:{
          jj_consume_token(LPAREN);
          ret = Expression();
          jj_consume_token(RPAREN);
          break;
          }
        default:
          jj_la1[7] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Object evalVar(Object obj, String var) throws ParseException {Token token; Object temp;
obj = EvalObjectUtils.parseObject(obj, var);
    label_3:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case POINT:
      case LBRACKET:{
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_3;
      }
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case POINT:{
        jj_consume_token(POINT);
        token = jj_consume_token(VAR);
        obj = evalVar(obj, token.image);
        break;
        }
      case LBRACKET:{
        jj_consume_token(LBRACKET);
        obj = evalArray(obj);
        jj_consume_token(RBRACKET);
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_4:
    while (true) {
      switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
      case DEFAULT_VAL:{
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_4;
      }
      jj_consume_token(DEFAULT_VAL);
      temp = EvalExpression();
obj = obj != null ? obj : temp;
    }
{if ("" != null) return obj;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Object evalArray(Object obj) throws ParseException {Token token; Object temp;
    switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
    case NUMBER:{
      token = jj_consume_token(NUMBER);
obj = EvalObjectUtils.parseArray(obj, token.image);
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      if (jj_2_2(2)) {
        jj_consume_token(QUOTATION);
        token = jj_consume_token(VAR);
        jj_consume_token(QUOTATION);
obj = EvalObjectUtils.parseObject(obj, token.image);
      } else {
        switch (jj_ntk == -1 ? jj_ntk_f() : jj_ntk) {
        case QUOTATION:{
          jj_consume_token(QUOTATION);
          token = jj_consume_token(NUMBER);
          jj_consume_token(QUOTATION);
obj = EvalObjectUtils.parseObject(obj, token.image);
          break;
          }
        case BANG:
        case LPAREN:
        case TRUE:
        case FALSE:
        case NULL:
        case NUMBER:
        case VAR:{
          temp = Expression();
obj = EvalObjectUtils.parse(obj, temp);
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
{if ("" != null) return obj;}
    throw new IllegalStateException ("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(QUOTATION)) return true;
    if (jj_scan_token(VAR)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(QUOTATION)) return true;
    if (jj_scan_token(VAR)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public EvalParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[13];
  static private int[] jj_la1_0;
  static {
	   jj_la1_init_0();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x8,0x1000,0x2000,0xfc000,0xfc000,0x1f00144,0xf00000,0x1000104,0x420,0x420,0x80,0x800000,0x1f00144,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with InputStream.
   * @param stream input stream
   */
  public EvalParser(final java.io.InputStream stream) {
	  this(stream, null);
  }

  /**
   * Constructor with InputStream and supplied encoding
   * @param stream input stream
   * @param encoding charset to be used
   */
  public EvalParser(final java.io.InputStream stream, final java.nio.charset.Charset encoding) {
   jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
	 token_source = new EvalParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 13; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param stream input stream
   */
  public void ReInit(final java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /**
   * Reinitialise
   * @param stream input stream
   * @param encoding charset to be used
   */
  public void ReInit(final java.io.InputStream stream, final java.nio.charset.Charset encoding) {
    jj_input_stream.reInit(stream, encoding, 1, 1);
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 13; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with InputStream.
   * @param stream char stream
   */
  public EvalParser(final java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new EvalParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
   for (int i = 0; i < 13; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param stream char stream
   */
  public void ReInit(final java.io.Reader stream) {
	if (jj_input_stream == null) {
	  jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	  jj_input_stream.reInit(stream, 1, 1);
  }
	if (token_source == null) {
 token_source = new EvalParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
   for (int i = 0; i < 13; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public EvalParser(final EvalParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 13; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final EvalParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 13; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    if (token.next != null)
      token = token.next;
    else {
      token.next = token_source.getNextToken();
      token = token.next;
    }
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  private static final class LookaheadSuccess extends IllegalStateException {}
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   if (token.next != null)
     token = token.next;
   else
     token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private int jj_ntk_f() {
    jj_nt = token.next;
    if (jj_nt == null) {
      token.next = token_source.getNextToken();
      jj_ntk = token.next.kind;
      return jj_ntk;
    }
    jj_ntk = jj_nt.kind;
    return jj_ntk;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[27];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 13; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 27; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
