package com.xadade.press.recommender;

import com.xadade.press.domain.PressRelevance;
import com.xadade.press.common.PressUtils;
import org.apache.mahout.cf.taste.impl.neighborhood.ThresholdUserNeighborhood;
import org.apache.mahout.cf.taste.impl.recommender.GenericUserBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.PearsonCorrelationSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.neighborhood.UserNeighborhood;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.UserBasedRecommender;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

import java.util.*;

/**
 * 基于用户的协同过滤
 */
public class PressUserBasedRecommender
{

	/**
	 * 批量为用户进行新闻推荐
	 * @param userIds 推荐的用户ID数组
	 * @param newsPreferDegrees 参与推荐的用户行为数据
	 * @param size 条数
	 * @param threshold 相似阈值 这个数值越高  推荐精准越高  但是推荐的数据也越少 最高为 你给用户设置的喜好值最高值 也就是preference的最高值
	 * @return 推荐结果集合
	 */
	public Map<Long, List<RecommendedItem>> recommend(List<Long> userIds, List<PressRelevance> newsPreferDegrees, Integer size, float threshold) {
		Map<Long, List<RecommendedItem>> res = new HashMap<>();
		try {
			// 构建数据模型
			DataModel dataModel = PressUtils.buildDataModel(newsPreferDegrees);
			// 用户相似度计算
			UserSimilarity userSimilarity = new PearsonCorrelationSimilarity(dataModel);
			// 构建 近邻对象  threshold
			UserNeighborhood neighborhood = new ThresholdUserNeighborhood(threshold, userSimilarity, dataModel);
			//构建推荐器
			UserBasedRecommender recommender = new GenericUserBasedRecommender(dataModel, neighborhood, userSimilarity);
			/// 为每个用户进行推荐
			for (Long userId : userIds) {
				List<RecommendedItem> recItems = recommender.recommend(userId, size);
				res.put(userId, recItems);
			}
			return res;
		}catch (Exception e) {
			e.printStackTrace();
			return res;
		}
	}

	public Map<Long, List<RecommendedItem>> recommend(List<Long> userIds, List<PressRelevance> newsPreferDegrees, Integer size) {
		return recommend(userIds, newsPreferDegrees, size, 0f);
	}

}
