package com.xadade.press.recommender;

import com.xadade.press.domain.PressRelevance;
import com.xadade.press.common.PressUtils;
import org.apache.mahout.cf.taste.impl.recommender.GenericItemBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.PearsonCorrelationSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;

import java.util.*;

/**
 * 基于内容的协同过滤
 */
public class PressNewsBasedRecommender
{

	/**
     * 批量为用户进行新闻推荐
	 * @param userIds 推荐的用户ID数组
	 * @param newsPreferDegrees 参与推荐的用户行为数据
	 * @param size 条数
	 * @return 推荐结果集合
	 */
	public Map<Long, List<RecommendedItem>> recommend(List<Long> userIds, List<PressRelevance> newsPreferDegrees, Integer size) {
		Map<Long, List<RecommendedItem>> res = new HashMap<>();
		try {
			// 构建数据模型
			DataModel dataModel = PressUtils.buildDataModel(newsPreferDegrees);
			// 内容相似度计算
			ItemSimilarity itemSimilarity = new PearsonCorrelationSimilarity(dataModel);
			// 构建推荐器
			GenericItemBasedRecommender recommender = new GenericItemBasedRecommender(dataModel, itemSimilarity);
			// 为每个用户进行推荐
			for (Long userId : userIds) {
				List<RecommendedItem> recItems = recommender.recommend(userId, size);
				res.put(userId, recItems);
			}
			return res;
		}catch (Exception e) {
			e.printStackTrace();
			return res;
		}
	}

}
