package com.xadade.press.common;

import com.xadade.press.domain.PressRelevance;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import java.util.*;

/**
 * 工具类
 */
public class PressUtils {

    public static DataModel buildDataModel(List<PressRelevance> newsPreferDegrees) {
        FastByIDMap<LinkedList<Preference>> linkedListFastByIDMap = new FastByIDMap<>();
        // 构建数据
        for (PressRelevance newsPreferDegree : newsPreferDegrees) {
            //创建该用户下的item list
            LinkedList<Preference> preferences = linkedListFastByIDMap.get(newsPreferDegree.getUserId());
            if (preferences == null) preferences = new LinkedList<>();
            //构建偏好
            GenericPreference genericPreference = new GenericPreference(newsPreferDegree.getUserId(), newsPreferDegree.getNewsId(), newsPreferDegree.getPreferDegree());
            preferences.add(genericPreference);
            //重新写入map集合
            linkedListFastByIDMap.put(newsPreferDegree.getUserId(), preferences);
        }
        // 遍历map集合
        Set<Map.Entry<Long, LinkedList<Preference>>> entries = linkedListFastByIDMap.entrySet();
        // 构建偏好集合
        FastByIDMap<PreferenceArray> arrayFastByIDMap = new FastByIDMap<>();
        for (Map.Entry<Long, LinkedList<Preference>> entry : entries) {
            Long key = entry.getKey();
            LinkedList<Preference> value = entry.getValue();
            arrayFastByIDMap.put(key, new GenericUserPreferenceArray(value));
        }
        //最后 构建数据模型
        return new GenericDataModel(arrayFastByIDMap);
    }

}
