package cn.valot.common.secure;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "valot.mfa")
public class MFAConfig {
    // 发行者（项目名），可为空，注：不允许包含冒号
    private String issuer = "valot.cn";

    // 生成的key长度( Generate secret key length)
    private int secretSize = 32;

    // Java实现随机数算法
    private String randomAlgorithm = "SHA1PRNG";

    // 最多可偏移的时间, 假设为2，表示计算前面2次、当前时间、后面2次，共5个时间内的验证码 最大 17
    private int windowSize = 1;

    // 每次时间长度，默认30秒
    private long refreshTime = 30L;

    public String getIssuer() {
        return issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public int getSecretSize() {
        return secretSize;
    }

    public void setSecretSize(int secretSize) {
        this.secretSize = secretSize;
    }

    public String getRandomAlgorithm() {
        return randomAlgorithm;
    }

    public void setRandomAlgorithm(String randomAlgorithm) {
        this.randomAlgorithm = randomAlgorithm;
    }

    public int getWindowSize() {
        return windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public long getRefreshTime() {
        return refreshTime;
    }

    public void setRefreshTime(long refreshTime) {
        this.refreshTime = refreshTime;
    }
}
