package cn.valot.common.data.excel.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.read.listener.ReadListener;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;

/**
 * excelUtil
 * 需要依赖：com.alibaba:easyexcel:3.2.1
 * @author sa@linkot.cn
 */
public class ExcelUtils {
    public static boolean contain(ExcelContentProperty property, String name){
        ExcelProperty annotation = property.getField().getAnnotation(ExcelProperty.class);
        return Arrays.asList(annotation.value()).contains(name);
    }
    public static void export(HttpServletResponse response, List<?> list, Class<?> clz){
        export(response, list, clz, 0, 0, null);
    }
    public static void export(HttpServletResponse response, List<?> list, Class<?> clz, Integer freezeLeft, Integer freezeTop, String filterRow){
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        try{
            String fileName = URLEncoder.encode(String.valueOf(System.currentTimeMillis()), "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx;filename="+fileName);
            EasyExcel.write(response.getOutputStream(), clz)
                .sheet(0)
                .registerWriteHandler(new ExcelFreezeAndFilterHandler(freezeLeft, freezeTop, filterRow))
                .doWrite(list);
        }catch (IOException e){
            throw new RuntimeException(e);
        }
    }

    public static void importExcel(MultipartFile file,
        Class<?> clz,
        ReadListener<?> listener) {
        importExcel(file, "file", 0, clz, listener);
    }
    public static void importExcel(MultipartFile file,
        String part, int table, Class<?> clz, ReadListener<?> listener){
        InputStream is = null;
        try{
            if (file == null){
                throw new IllegalArgumentException("请上传文件");
            }
            is = file.getInputStream();
            EasyExcel.read(is, clz, listener)
                .sheet(table)
                .doRead();
        }catch (IOException e){
            throw new RuntimeException(e);
        }finally {
            try{
                if (is!=null) is.close();
            }catch (IOException ignored){
            }
        }
    }
}
