package cn.valot.common.data.excel.excel;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.util.StringUtils;

public class ExcelFreezeAndFilterHandler implements SheetWriteHandler {
    private final Integer freezeLeft;
    private final Integer freezeTop;
    private final String filterRow;

    public ExcelFreezeAndFilterHandler(Integer freezeLeft, Integer freezeTop, String filterRow) {
        this.freezeLeft = freezeLeft;
        this.freezeTop = freezeTop;
        this.filterRow = filterRow;
    }

    @Override
    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder,
        WriteSheetHolder writeSheetHolder) {
        Sheet sheet = writeSheetHolder.getSheet();
        sheet.createFreezePane(freezeLeft, freezeTop);
        if (StringUtils.hasText(this.filterRow)){
            sheet.setAutoFilter(CellRangeAddress.valueOf("1:1"));
        }
    }
}
