package cn.valot.common.data;

import java.util.Locale;

public class StringUtils {
    public static String upperHump(String src){
        return src.substring(0, 1).toUpperCase(Locale.ROOT) + src.substring(1);
    }
    public static String lowerHump(String src){
        return src.substring(0, 1).toLowerCase(Locale.ROOT) + src.substring(1);
    }

    public static boolean notEmpty(String typeName) {
        return typeName != null && !typeName.isEmpty();
    }

    /**
     * 循环重复的字符片段
     * @param frag 片段 eg：!
     * @param nth 重复次数 eg: 3
     * @return eg：!!!
     */
    public static String replicate(String frag, int nth) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < nth; i++) result.append(frag);
        return result.toString();
    }
}
