package cn.valot.common.data;

import java.util.Random;

/**
 * 随机工具类
 */
public class RandomUtil {
    public static String ALPHANUMERIC = "QWERTYUIOPASDFGHJKLZXCVBNM1234567890qwertyuiopasdfghjklzxcvbnm";
    public static String NUMERIC = "0123456789";
    private final static Random random = new Random();

    /**
     * 生成随机字母数字
     * @param length 长度
     * @return 随机字母字符串
     */
    public static String randomAlphanumeric(int length){
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; i++) {
            sb.append(ALPHANUMERIC.charAt(random.nextInt(ALPHANUMERIC.length())));
        }
        return sb.toString();
    }

    /**
     * 生成随机数字
     * @param length 长度
     * @return 随机字母字符串
     */
    public static String randomNumeric(int length){
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; i++) {
            sb.append(NUMERIC.charAt(random.nextInt(NUMERIC.length())));
        }
        return sb.toString();
    }

    /**
     * 随机 0 - size 的整数
     */
    public static Integer randomInt(int size) {
        return random.nextInt(size);
    }
}
