package cn.valot.common.data;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;

import java.awt.image.BufferedImage;
import java.util.Map;

/**
 * 二维码工具类
 * 需要第三方包：com.google.zxing:core:3.5.1
 */
public class Qrs {
    private static final Map<EncodeHintType, Object> HINT_TABLE =
        Maps.asTable(
            new Dict<>(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L),
            new Dict<>(EncodeHintType.CHARACTER_SET, "utf-8"),
            new Dict<>(EncodeHintType.MARGIN, 1)
        );

    public static BufferedImage qrCode(String text, int size){
        try{
            QRCodeWriter writer = new QRCodeWriter();
            BitMatrix matrix = writer.encode(text, BarcodeFormat.QR_CODE, size, size, HINT_TABLE);
            int width = matrix.getWidth();
            int height = matrix.getHeight();
            BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
            for (int w = 0; w < width; w++){
                for (int h = 0; h < height; h++){
                    image.setRGB(w, h, matrix.get(w, h)? 0x000000 : 0xFFFFFF);
                }
            }
            return image;
        }catch (Exception ex){
            ex.printStackTrace();
            return null;
        }
    }
}
