package cn.valot.common.data;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 字段映射工具类
 * @author sa@linkot.cn
 */
public class ObjectMapper {

    /**
     * 映射为新类型
     * @param value 原对象
     * @param type 新对象类型
     * @param ignoredFields 忽略的字段
     * @return 新对象
     * @param <T> any
     */
    public static  <T> T map(Object value, Class<T> type, String... ignoredFields){
        try {
            T i = type.newInstance();
            return map(value, i, ignoredFields);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 映射到新对象
     * @param value 原对象
     * @param i 新对象
     * @param ignoredFields 忽略的字段
     * @return 映射字段后的新对象
     */
    public static <T> T map(Object value, T i, String... ignoredFields){
        if (value == null) return null;
        Class<?> sc = value.getClass();
        Class<?> dc = i.getClass();
        List<Field> fields = ReflectUtils.getDeclaredFields(sc);
        Map<String, Class<?>> fieldsMap = Maps.parseMap(fields, Field::getName, Field::getType);
        fieldsMap.forEach((k, v)->{
            if (ignoredFields != null && ignoredFields.length != 0 &&Arrays.asList(ignoredFields).contains(k)){
                return;
            }
            String upperField = StringUtils.upperHump(k);
            try{
                Method getMethod = sc.getMethod("get" + upperField);
                Method setMethod = dc.getMethod("set" + upperField, v);
                Object val = getMethod.invoke(value);
                if (val == null) {
                    return;
                }
                setMethod.invoke(i, val);
            }catch (NoSuchMethodException ignored){
            } catch (InvocationTargetException | IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        return i;
    }
}
