package cn.valot.common.data;

/**
 * 脱敏工具类
 */
public class Desensitization {
    /**
     * 字符串脱敏
     * @param src 原字符串 e.g. 123456789
     * @param skip 开头保留字符数 e.g. 2
     * @param left 结尾保留字符数 e.g. 2
     * @param replaceTo 替换成的字符 e.g. *
     * @param nth 替换的字符重复次数 e.g. 4
     * @return e.g. 12****89
     */
    public static String replace(String src, int skip, int left, String replaceTo, int nth){
        String replace = StringUtils.replicate(replaceTo, nth);
        if (!StringUtils.notEmpty(src)){
            return replace;
        }
        if (src.length()<skip+left){
            return skip>left ?
                    src.substring(0, 1).concat(replace) :
                    replace.concat(src.substring(src.length()-1));
        }
        return src.substring(0, skip)
                .concat(replace)
                .concat(left>0 ? src.substring(src.length()-left) : "");
    }
}
